<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Addresses StructType
 * @subpackage Structs
 */
class Addresses extends AbstractStructBase
{
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\SubscriberAddress[]
     */
    public $Address;
    /**
     * Constructor method for Addresses
     * @uses Addresses::setAddress()
     * @param \App\Library\ExactTarget\StructType\SubscriberAddress[] $address
     */
    public function __construct(array $address = array())
    {
        $this
            ->setAddress($address);
    }
    /**
     * Get Address value
     * @return \App\Library\ExactTarget\StructType\SubscriberAddress[]|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\SubscriberAddress[] $address
     * @return \App\Library\ExactTarget\StructType\Addresses
     */
    public function setAddress(array $address = array())
    {
        foreach ($address as $addressesAddressItem) {
            // validation for constraint: itemType
            if (!$addressesAddressItem instanceof \App\Library\ExactTarget\StructType\SubscriberAddress) {
                throw new \InvalidArgumentException(sprintf('The Address property can only contain items of \App\Library\ExactTarget\StructType\SubscriberAddress, "%s" given', is_object($addressesAddressItem) ? get_class($addressesAddressItem) : gettype($addressesAddressItem)), __LINE__);
            }
        }
        $this->Address = $address;
        return $this;
    }
    /**
     * Add item to Address value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\SubscriberAddress $item
     * @return \App\Library\ExactTarget\StructType\Addresses
     */
    public function addToAddress(\App\Library\ExactTarget\StructType\SubscriberAddress $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\SubscriberAddress) {
            throw new \InvalidArgumentException(sprintf('The Address property can only contain items of \App\Library\ExactTarget\StructType\SubscriberAddress, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Address[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\Addresses
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
