<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddressStatus StructType
 * @subpackage Structs
 */
class AddressStatus extends AbstractStructBase
{
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * Constructor method for AddressStatus
     * @uses AddressStatus::setStatus()
     * @param string $status
     */
    public function __construct($status = null)
    {
        $this
            ->setStatus($status);
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \App\Library\ExactTarget\EnumType\SubscriberAddressStatus::valueIsValid()
     * @uses \App\Library\ExactTarget\EnumType\SubscriberAddressStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \App\Library\ExactTarget\StructType\AddressStatus
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\App\Library\ExactTarget\EnumType\SubscriberAddressStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \App\Library\ExactTarget\EnumType\SubscriberAddressStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\AddressStatus
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
