<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ActivityInstances StructType
 * @subpackage Structs
 */
class ActivityInstances extends AbstractStructBase
{
    /**
     * The ActivityInstance
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\AutomationActivityInstance[]
     */
    public $ActivityInstance;
    /**
     * Constructor method for ActivityInstances
     * @uses ActivityInstances::setActivityInstance()
     * @param \App\Library\ExactTarget\StructType\AutomationActivityInstance[] $activityInstance
     */
    public function __construct(array $activityInstance = array())
    {
        $this
            ->setActivityInstance($activityInstance);
    }
    /**
     * Get ActivityInstance value
     * @return \App\Library\ExactTarget\StructType\AutomationActivityInstance[]|null
     */
    public function getActivityInstance()
    {
        return $this->ActivityInstance;
    }
    /**
     * Set ActivityInstance value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\AutomationActivityInstance[] $activityInstance
     * @return \App\Library\ExactTarget\StructType\ActivityInstances
     */
    public function setActivityInstance(array $activityInstance = array())
    {
        foreach ($activityInstance as $activityInstancesActivityInstanceItem) {
            // validation for constraint: itemType
            if (!$activityInstancesActivityInstanceItem instanceof \App\Library\ExactTarget\StructType\AutomationActivityInstance) {
                throw new \InvalidArgumentException(sprintf('The ActivityInstance property can only contain items of \App\Library\ExactTarget\StructType\AutomationActivityInstance, "%s" given', is_object($activityInstancesActivityInstanceItem) ? get_class($activityInstancesActivityInstanceItem) : gettype($activityInstancesActivityInstanceItem)), __LINE__);
            }
        }
        $this->ActivityInstance = $activityInstance;
        return $this;
    }
    /**
     * Add item to ActivityInstance value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\AutomationActivityInstance $item
     * @return \App\Library\ExactTarget\StructType\ActivityInstances
     */
    public function addToActivityInstance(\App\Library\ExactTarget\StructType\AutomationActivityInstance $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\AutomationActivityInstance) {
            throw new \InvalidArgumentException(sprintf('The ActivityInstance property can only contain items of \App\Library\ExactTarget\StructType\AutomationActivityInstance, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ActivityInstance[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\ActivityInstances
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
