<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Activities StructType
 * @subpackage Structs
 */
class Activities extends AbstractStructBase
{
    /**
     * The Activity
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\AutomationActivity[]
     */
    public $Activity;
    /**
     * Constructor method for Activities
     * @uses Activities::setActivity()
     * @param \App\Library\ExactTarget\StructType\AutomationActivity[] $activity
     */
    public function __construct(array $activity = array())
    {
        $this
            ->setActivity($activity);
    }
    /**
     * Get Activity value
     * @return \App\Library\ExactTarget\StructType\AutomationActivity[]|null
     */
    public function getActivity()
    {
        return $this->Activity;
    }
    /**
     * Set Activity value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\AutomationActivity[] $activity
     * @return \App\Library\ExactTarget\StructType\Activities
     */
    public function setActivity(array $activity = array())
    {
        foreach ($activity as $activitiesActivityItem) {
            // validation for constraint: itemType
            if (!$activitiesActivityItem instanceof \App\Library\ExactTarget\StructType\AutomationActivity) {
                throw new \InvalidArgumentException(sprintf('The Activity property can only contain items of \App\Library\ExactTarget\StructType\AutomationActivity, "%s" given', is_object($activitiesActivityItem) ? get_class($activitiesActivityItem) : gettype($activitiesActivityItem)), __LINE__);
            }
        }
        $this->Activity = $activity;
        return $this;
    }
    /**
     * Add item to Activity value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\AutomationActivity $item
     * @return \App\Library\ExactTarget\StructType\Activities
     */
    public function addToActivity(\App\Library\ExactTarget\StructType\AutomationActivity $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\AutomationActivity) {
            throw new \InvalidArgumentException(sprintf('The Activity property can only contain items of \App\Library\ExactTarget\StructType\AutomationActivity, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Activity[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\Activities
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
