<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountUser StructType
 * @subpackage Structs
 */
class AccountUser extends APIObject
{
    /**
     * The UserID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $UserID;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Name;
    /**
     * The Email
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Email;
    /**
     * The Delete
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Delete;
    /**
     * The AccountUserID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AccountUserID;
    /**
     * The Password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * The MustChangePassword
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $MustChangePassword;
    /**
     * The ActiveFlag
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $ActiveFlag;
    /**
     * The ChallengePhrase
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ChallengePhrase;
    /**
     * The ChallengeAnswer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ChallengeAnswer;
    /**
     * The UserPermissions
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Library\ExactTarget\StructType\UserAccess[]
     */
    public $UserPermissions;
    /**
     * The LastSuccessfulLogin
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastSuccessfulLogin;
    /**
     * The IsAPIUser
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IsAPIUser;
    /**
     * The NotificationEmailAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NotificationEmailAddress;
    /**
     * The IsLocked
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IsLocked;
    /**
     * The Unlock
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Unlock;
    /**
     * The BusinessUnit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $BusinessUnit;
    /**
     * The DefaultBusinessUnit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $DefaultBusinessUnit;
    /**
     * The DefaultApplication
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DefaultApplication;
    /**
     * The Locale
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\Locale
     */
    public $Locale;
    /**
     * The TimeZone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\TimeZone
     */
    public $TimeZone;
    /**
     * The DefaultBusinessUnitObject
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\BusinessUnit
     */
    public $DefaultBusinessUnitObject;
    /**
     * The AssociatedBusinessUnits
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\AssociatedBusinessUnits
     */
    public $AssociatedBusinessUnits;
    /**
     * The Roles
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\Roles
     */
    public $Roles;
    /**
     * The LanguageLocale
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\Locale
     */
    public $LanguageLocale;
    /**
     * The SsoIdentities
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\SsoIdentities
     */
    public $SsoIdentities;
    /**
     * Constructor method for AccountUser
     * @uses AccountUser::setUserID()
     * @uses AccountUser::setName()
     * @uses AccountUser::setEmail()
     * @uses AccountUser::setDelete()
     * @uses AccountUser::setAccountUserID()
     * @uses AccountUser::setPassword()
     * @uses AccountUser::setMustChangePassword()
     * @uses AccountUser::setActiveFlag()
     * @uses AccountUser::setChallengePhrase()
     * @uses AccountUser::setChallengeAnswer()
     * @uses AccountUser::setUserPermissions()
     * @uses AccountUser::setLastSuccessfulLogin()
     * @uses AccountUser::setIsAPIUser()
     * @uses AccountUser::setNotificationEmailAddress()
     * @uses AccountUser::setIsLocked()
     * @uses AccountUser::setUnlock()
     * @uses AccountUser::setBusinessUnit()
     * @uses AccountUser::setDefaultBusinessUnit()
     * @uses AccountUser::setDefaultApplication()
     * @uses AccountUser::setLocale()
     * @uses AccountUser::setTimeZone()
     * @uses AccountUser::setDefaultBusinessUnitObject()
     * @uses AccountUser::setAssociatedBusinessUnits()
     * @uses AccountUser::setRoles()
     * @uses AccountUser::setLanguageLocale()
     * @uses AccountUser::setSsoIdentities()
     * @param string $userID
     * @param string $name
     * @param string $email
     * @param int $delete
     * @param int $accountUserID
     * @param string $password
     * @param bool $mustChangePassword
     * @param bool $activeFlag
     * @param string $challengePhrase
     * @param string $challengeAnswer
     * @param \App\Library\ExactTarget\StructType\UserAccess[] $userPermissions
     * @param string $lastSuccessfulLogin
     * @param bool $isAPIUser
     * @param string $notificationEmailAddress
     * @param bool $isLocked
     * @param bool $unlock
     * @param int $businessUnit
     * @param int $defaultBusinessUnit
     * @param string $defaultApplication
     * @param \App\Library\ExactTarget\StructType\Locale $locale
     * @param \App\Library\ExactTarget\StructType\TimeZone $timeZone
     * @param \App\Library\ExactTarget\StructType\BusinessUnit $defaultBusinessUnitObject
     * @param \App\Library\ExactTarget\StructType\AssociatedBusinessUnits $associatedBusinessUnits
     * @param \App\Library\ExactTarget\StructType\Roles $roles
     * @param \App\Library\ExactTarget\StructType\Locale $languageLocale
     * @param \App\Library\ExactTarget\StructType\SsoIdentities $ssoIdentities
     */
    public function __construct($userID = null, $name = null, $email = null, $delete = 0, $accountUserID = null, $password = null, $mustChangePassword = null, $activeFlag = null, $challengePhrase = null, $challengeAnswer = null, array $userPermissions = array(), $lastSuccessfulLogin = null, $isAPIUser = null, $notificationEmailAddress = null, $isLocked = null, $unlock = null, $businessUnit = null, $defaultBusinessUnit = null, $defaultApplication = null, \App\Library\ExactTarget\StructType\Locale $locale = null, \App\Library\ExactTarget\StructType\TimeZone $timeZone = null, \App\Library\ExactTarget\StructType\BusinessUnit $defaultBusinessUnitObject = null, \App\Library\ExactTarget\StructType\AssociatedBusinessUnits $associatedBusinessUnits = null, \App\Library\ExactTarget\StructType\Roles $roles = null, \App\Library\ExactTarget\StructType\Locale $languageLocale = null, \App\Library\ExactTarget\StructType\SsoIdentities $ssoIdentities = null)
    {
        $this
            ->setUserID($userID)
            ->setName($name)
            ->setEmail($email)
            ->setDelete($delete)
            ->setAccountUserID($accountUserID)
            ->setPassword($password)
            ->setMustChangePassword($mustChangePassword)
            ->setActiveFlag($activeFlag)
            ->setChallengePhrase($challengePhrase)
            ->setChallengeAnswer($challengeAnswer)
            ->setUserPermissions($userPermissions)
            ->setLastSuccessfulLogin($lastSuccessfulLogin)
            ->setIsAPIUser($isAPIUser)
            ->setNotificationEmailAddress($notificationEmailAddress)
            ->setIsLocked($isLocked)
            ->setUnlock($unlock)
            ->setBusinessUnit($businessUnit)
            ->setDefaultBusinessUnit($defaultBusinessUnit)
            ->setDefaultApplication($defaultApplication)
            ->setLocale($locale)
            ->setTimeZone($timeZone)
            ->setDefaultBusinessUnitObject($defaultBusinessUnitObject)
            ->setAssociatedBusinessUnits($associatedBusinessUnits)
            ->setRoles($roles)
            ->setLanguageLocale($languageLocale)
            ->setSsoIdentities($ssoIdentities);
    }
    /**
     * Get UserID value
     * @return string
     */
    public function getUserID()
    {
        return $this->UserID;
    }
    /**
     * Set UserID value
     * @param string $userID
     * @return \App\Library\ExactTarget\StructType\AccountUser
     */
    public function setUserID($userID = null)
    {
        // validation for constraint: string
        if (!is_null($userID) && !is_string($userID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userID)), __LINE__);
        }
        $this->UserID = $userID;
        return $this;
    }
    /**
     * Get Name value
     * @return string
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \App\Library\ExactTarget\StructType\AccountUser
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Email value
     * @return string
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \App\Library\ExactTarget\StructType\AccountUser
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Get Delete value
     * @return int
     */
    public function getDelete()
    {
        return $this->Delete;
    }
    /**
     * Set Delete value
     * @param int $delete
     * @return \App\Library\ExactTarget\StructType\AccountUser
     */
    public function setDelete($delete = 0)
    {
        // validation for constraint: int
        if (!is_null($delete) && !is_numeric($delete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($delete)), __LINE__);
        }
        $this->Delete = $delete;
        return $this;
    }
    /**
     * Get AccountUserID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAccountUserID()
    {
        return isset($this->AccountUserID) ? $this->AccountUserID : null;
    }
    /**
     * Set AccountUserID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $accountUserID
     * @return \App\Library\ExactTarget\StructType\AccountUser
     */
    public function setAccountUserID($accountUserID = null)
    {
        // validation for constraint: int
        if (!is_null($accountUserID) && !is_numeric($accountUserID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountUserID)), __LINE__);
        }
        if (is_null($accountUserID) || (is_array($accountUserID) && empty($accountUserID))) {
            unset($this->AccountUserID);
        } else {
            $this->AccountUserID = $accountUserID;
        }
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \App\Library\ExactTarget\StructType\AccountUser
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get MustChangePassword value
     * @return bool|null
     */
    public function getMustChangePassword()
    {
        return $this->MustChangePassword;
    }
    /**
     * Set MustChangePassword value
     * @param bool $mustChangePassword
     * @return \App\Library\ExactTarget\StructType\AccountUser
     */
    public function setMustChangePassword($mustChangePassword = null)
    {
        // validation for constraint: boolean
        if (!is_null($mustChangePassword) && !is_bool($mustChangePassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($mustChangePassword)), __LINE__);
        }
        $this->MustChangePassword = $mustChangePassword;
        return $this;
    }
    /**
     * Get ActiveFlag value
     * @return bool|null
     */
    public function getActiveFlag()
    {
        return $this->ActiveFlag;
    }
    /**
     * Set ActiveFlag value
     * @param bool $activeFlag
     * @return \App\Library\ExactTarget\StructType\AccountUser
     */
    public function setActiveFlag($activeFlag = null)
    {
        // validation for constraint: boolean
        if (!is_null($activeFlag) && !is_bool($activeFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($activeFlag)), __LINE__);
        }
        $this->ActiveFlag = $activeFlag;
        return $this;
    }
    /**
     * Get ChallengePhrase value
     * @return string|null
     */
    public function getChallengePhrase()
    {
        return $this->ChallengePhrase;
    }
    /**
     * Set ChallengePhrase value
     * @param string $challengePhrase
     * @return \App\Library\ExactTarget\StructType\AccountUser
     */
    public function setChallengePhrase($challengePhrase = null)
    {
        // validation for constraint: string
        if (!is_null($challengePhrase) && !is_string($challengePhrase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($challengePhrase)), __LINE__);
        }
        $this->ChallengePhrase = $challengePhrase;
        return $this;
    }
    /**
     * Get ChallengeAnswer value
     * @return string|null
     */
    public function getChallengeAnswer()
    {
        return $this->ChallengeAnswer;
    }
    /**
     * Set ChallengeAnswer value
     * @param string $challengeAnswer
     * @return \App\Library\ExactTarget\StructType\AccountUser
     */
    public function setChallengeAnswer($challengeAnswer = null)
    {
        // validation for constraint: string
        if (!is_null($challengeAnswer) && !is_string($challengeAnswer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($challengeAnswer)), __LINE__);
        }
        $this->ChallengeAnswer = $challengeAnswer;
        return $this;
    }
    /**
     * Get UserPermissions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Library\ExactTarget\StructType\UserAccess[]|null
     */
    public function getUserPermissions()
    {
        return isset($this->UserPermissions) ? $this->UserPermissions : null;
    }
    /**
     * Set UserPermissions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\UserAccess[] $userPermissions
     * @return \App\Library\ExactTarget\StructType\AccountUser
     */
    public function setUserPermissions(array $userPermissions = array())
    {
        foreach ($userPermissions as $accountUserUserPermissionsItem) {
            // validation for constraint: itemType
            if (!$accountUserUserPermissionsItem instanceof \App\Library\ExactTarget\StructType\UserAccess) {
                throw new \InvalidArgumentException(sprintf('The UserPermissions property can only contain items of \App\Library\ExactTarget\StructType\UserAccess, "%s" given', is_object($accountUserUserPermissionsItem) ? get_class($accountUserUserPermissionsItem) : gettype($accountUserUserPermissionsItem)), __LINE__);
            }
        }
        if (is_null($userPermissions) || (is_array($userPermissions) && empty($userPermissions))) {
            unset($this->UserPermissions);
        } else {
            $this->UserPermissions = $userPermissions;
        }
        return $this;
    }
    /**
     * Add item to UserPermissions value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\UserAccess $item
     * @return \App\Library\ExactTarget\StructType\AccountUser
     */
    public function addToUserPermissions(\App\Library\ExactTarget\StructType\UserAccess $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\UserAccess) {
            throw new \InvalidArgumentException(sprintf('The UserPermissions property can only contain items of \App\Library\ExactTarget\StructType\UserAccess, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->UserPermissions[] = $item;
        return $this;
    }
    /**
     * Get LastSuccessfulLogin value
     * @return string|null
     */
    public function getLastSuccessfulLogin()
    {
        return $this->LastSuccessfulLogin;
    }
    /**
     * Set LastSuccessfulLogin value
     * @param string $lastSuccessfulLogin
     * @return \App\Library\ExactTarget\StructType\AccountUser
     */
    public function setLastSuccessfulLogin($lastSuccessfulLogin = null)
    {
        // validation for constraint: string
        if (!is_null($lastSuccessfulLogin) && !is_string($lastSuccessfulLogin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastSuccessfulLogin)), __LINE__);
        }
        $this->LastSuccessfulLogin = $lastSuccessfulLogin;
        return $this;
    }
    /**
     * Get IsAPIUser value
     * @return bool|null
     */
    public function getIsAPIUser()
    {
        return $this->IsAPIUser;
    }
    /**
     * Set IsAPIUser value
     * @param bool $isAPIUser
     * @return \App\Library\ExactTarget\StructType\AccountUser
     */
    public function setIsAPIUser($isAPIUser = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAPIUser) && !is_bool($isAPIUser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isAPIUser)), __LINE__);
        }
        $this->IsAPIUser = $isAPIUser;
        return $this;
    }
    /**
     * Get NotificationEmailAddress value
     * @return string|null
     */
    public function getNotificationEmailAddress()
    {
        return $this->NotificationEmailAddress;
    }
    /**
     * Set NotificationEmailAddress value
     * @param string $notificationEmailAddress
     * @return \App\Library\ExactTarget\StructType\AccountUser
     */
    public function setNotificationEmailAddress($notificationEmailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($notificationEmailAddress) && !is_string($notificationEmailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($notificationEmailAddress)), __LINE__);
        }
        $this->NotificationEmailAddress = $notificationEmailAddress;
        return $this;
    }
    /**
     * Get IsLocked value
     * @return bool|null
     */
    public function getIsLocked()
    {
        return $this->IsLocked;
    }
    /**
     * Set IsLocked value
     * @param bool $isLocked
     * @return \App\Library\ExactTarget\StructType\AccountUser
     */
    public function setIsLocked($isLocked = null)
    {
        // validation for constraint: boolean
        if (!is_null($isLocked) && !is_bool($isLocked)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isLocked)), __LINE__);
        }
        $this->IsLocked = $isLocked;
        return $this;
    }
    /**
     * Get Unlock value
     * @return bool|null
     */
    public function getUnlock()
    {
        return $this->Unlock;
    }
    /**
     * Set Unlock value
     * @param bool $unlock
     * @return \App\Library\ExactTarget\StructType\AccountUser
     */
    public function setUnlock($unlock = null)
    {
        // validation for constraint: boolean
        if (!is_null($unlock) && !is_bool($unlock)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($unlock)), __LINE__);
        }
        $this->Unlock = $unlock;
        return $this;
    }
    /**
     * Get BusinessUnit value
     * @return int|null
     */
    public function getBusinessUnit()
    {
        return $this->BusinessUnit;
    }
    /**
     * Set BusinessUnit value
     * @param int $businessUnit
     * @return \App\Library\ExactTarget\StructType\AccountUser
     */
    public function setBusinessUnit($businessUnit = null)
    {
        // validation for constraint: int
        if (!is_null($businessUnit) && !is_numeric($businessUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($businessUnit)), __LINE__);
        }
        $this->BusinessUnit = $businessUnit;
        return $this;
    }
    /**
     * Get DefaultBusinessUnit value
     * @return int|null
     */
    public function getDefaultBusinessUnit()
    {
        return $this->DefaultBusinessUnit;
    }
    /**
     * Set DefaultBusinessUnit value
     * @param int $defaultBusinessUnit
     * @return \App\Library\ExactTarget\StructType\AccountUser
     */
    public function setDefaultBusinessUnit($defaultBusinessUnit = null)
    {
        // validation for constraint: int
        if (!is_null($defaultBusinessUnit) && !is_numeric($defaultBusinessUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($defaultBusinessUnit)), __LINE__);
        }
        $this->DefaultBusinessUnit = $defaultBusinessUnit;
        return $this;
    }
    /**
     * Get DefaultApplication value
     * @return string|null
     */
    public function getDefaultApplication()
    {
        return $this->DefaultApplication;
    }
    /**
     * Set DefaultApplication value
     * @param string $defaultApplication
     * @return \App\Library\ExactTarget\StructType\AccountUser
     */
    public function setDefaultApplication($defaultApplication = null)
    {
        // validation for constraint: string
        if (!is_null($defaultApplication) && !is_string($defaultApplication)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($defaultApplication)), __LINE__);
        }
        $this->DefaultApplication = $defaultApplication;
        return $this;
    }
    /**
     * Get Locale value
     * @return \App\Library\ExactTarget\StructType\Locale|null
     */
    public function getLocale()
    {
        return $this->Locale;
    }
    /**
     * Set Locale value
     * @param \App\Library\ExactTarget\StructType\Locale $locale
     * @return \App\Library\ExactTarget\StructType\AccountUser
     */
    public function setLocale(\App\Library\ExactTarget\StructType\Locale $locale = null)
    {
        $this->Locale = $locale;
        return $this;
    }
    /**
     * Get TimeZone value
     * @return \App\Library\ExactTarget\StructType\TimeZone|null
     */
    public function getTimeZone()
    {
        return $this->TimeZone;
    }
    /**
     * Set TimeZone value
     * @param \App\Library\ExactTarget\StructType\TimeZone $timeZone
     * @return \App\Library\ExactTarget\StructType\AccountUser
     */
    public function setTimeZone(\App\Library\ExactTarget\StructType\TimeZone $timeZone = null)
    {
        $this->TimeZone = $timeZone;
        return $this;
    }
    /**
     * Get DefaultBusinessUnitObject value
     * @return \App\Library\ExactTarget\StructType\BusinessUnit|null
     */
    public function getDefaultBusinessUnitObject()
    {
        return $this->DefaultBusinessUnitObject;
    }
    /**
     * Set DefaultBusinessUnitObject value
     * @param \App\Library\ExactTarget\StructType\BusinessUnit $defaultBusinessUnitObject
     * @return \App\Library\ExactTarget\StructType\AccountUser
     */
    public function setDefaultBusinessUnitObject(\App\Library\ExactTarget\StructType\BusinessUnit $defaultBusinessUnitObject = null)
    {
        $this->DefaultBusinessUnitObject = $defaultBusinessUnitObject;
        return $this;
    }
    /**
     * Get AssociatedBusinessUnits value
     * @return \App\Library\ExactTarget\StructType\AssociatedBusinessUnits|null
     */
    public function getAssociatedBusinessUnits()
    {
        return $this->AssociatedBusinessUnits;
    }
    /**
     * Set AssociatedBusinessUnits value
     * @param \App\Library\ExactTarget\StructType\AssociatedBusinessUnits $associatedBusinessUnits
     * @return \App\Library\ExactTarget\StructType\AccountUser
     */
    public function setAssociatedBusinessUnits(\App\Library\ExactTarget\StructType\AssociatedBusinessUnits $associatedBusinessUnits = null)
    {
        $this->AssociatedBusinessUnits = $associatedBusinessUnits;
        return $this;
    }
    /**
     * Get Roles value
     * @return \App\Library\ExactTarget\StructType\Roles|null
     */
    public function getRoles()
    {
        return $this->Roles;
    }
    /**
     * Set Roles value
     * @param \App\Library\ExactTarget\StructType\Roles $roles
     * @return \App\Library\ExactTarget\StructType\AccountUser
     */
    public function setRoles(\App\Library\ExactTarget\StructType\Roles $roles = null)
    {
        $this->Roles = $roles;
        return $this;
    }
    /**
     * Get LanguageLocale value
     * @return \App\Library\ExactTarget\StructType\Locale|null
     */
    public function getLanguageLocale()
    {
        return $this->LanguageLocale;
    }
    /**
     * Set LanguageLocale value
     * @param \App\Library\ExactTarget\StructType\Locale $languageLocale
     * @return \App\Library\ExactTarget\StructType\AccountUser
     */
    public function setLanguageLocale(\App\Library\ExactTarget\StructType\Locale $languageLocale = null)
    {
        $this->LanguageLocale = $languageLocale;
        return $this;
    }
    /**
     * Get SsoIdentities value
     * @return \App\Library\ExactTarget\StructType\SsoIdentities|null
     */
    public function getSsoIdentities()
    {
        return $this->SsoIdentities;
    }
    /**
     * Set SsoIdentities value
     * @param \App\Library\ExactTarget\StructType\SsoIdentities $ssoIdentities
     * @return \App\Library\ExactTarget\StructType\AccountUser
     */
    public function setSsoIdentities(\App\Library\ExactTarget\StructType\SsoIdentities $ssoIdentities = null)
    {
        $this->SsoIdentities = $ssoIdentities;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\AccountUser
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
