<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountDataItem StructType
 * @subpackage Structs
 */
class AccountDataItem extends AbstractStructBase
{
    /**
     * The ChildAccountID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $ChildAccountID;
    /**
     * The BrandID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $BrandID;
    /**
     * The PrivateLabelID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PrivateLabelID;
    /**
     * The AccountType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AccountType;
    /**
     * Constructor method for AccountDataItem
     * @uses AccountDataItem::setChildAccountID()
     * @uses AccountDataItem::setBrandID()
     * @uses AccountDataItem::setPrivateLabelID()
     * @uses AccountDataItem::setAccountType()
     * @param int $childAccountID
     * @param int $brandID
     * @param int $privateLabelID
     * @param int $accountType
     */
    public function __construct($childAccountID = null, $brandID = null, $privateLabelID = null, $accountType = null)
    {
        $this
            ->setChildAccountID($childAccountID)
            ->setBrandID($brandID)
            ->setPrivateLabelID($privateLabelID)
            ->setAccountType($accountType);
    }
    /**
     * Get ChildAccountID value
     * @return int|null
     */
    public function getChildAccountID()
    {
        return $this->ChildAccountID;
    }
    /**
     * Set ChildAccountID value
     * @param int $childAccountID
     * @return \App\Library\ExactTarget\StructType\AccountDataItem
     */
    public function setChildAccountID($childAccountID = null)
    {
        // validation for constraint: int
        if (!is_null($childAccountID) && !is_numeric($childAccountID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($childAccountID)), __LINE__);
        }
        $this->ChildAccountID = $childAccountID;
        return $this;
    }
    /**
     * Get BrandID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getBrandID()
    {
        return isset($this->BrandID) ? $this->BrandID : null;
    }
    /**
     * Set BrandID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $brandID
     * @return \App\Library\ExactTarget\StructType\AccountDataItem
     */
    public function setBrandID($brandID = null)
    {
        // validation for constraint: int
        if (!is_null($brandID) && !is_numeric($brandID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($brandID)), __LINE__);
        }
        if (is_null($brandID) || (is_array($brandID) && empty($brandID))) {
            unset($this->BrandID);
        } else {
            $this->BrandID = $brandID;
        }
        return $this;
    }
    /**
     * Get PrivateLabelID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPrivateLabelID()
    {
        return isset($this->PrivateLabelID) ? $this->PrivateLabelID : null;
    }
    /**
     * Set PrivateLabelID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $privateLabelID
     * @return \App\Library\ExactTarget\StructType\AccountDataItem
     */
    public function setPrivateLabelID($privateLabelID = null)
    {
        // validation for constraint: int
        if (!is_null($privateLabelID) && !is_numeric($privateLabelID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($privateLabelID)), __LINE__);
        }
        if (is_null($privateLabelID) || (is_array($privateLabelID) && empty($privateLabelID))) {
            unset($this->PrivateLabelID);
        } else {
            $this->PrivateLabelID = $privateLabelID;
        }
        return $this;
    }
    /**
     * Get AccountType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAccountType()
    {
        return isset($this->AccountType) ? $this->AccountType : null;
    }
    /**
     * Set AccountType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $accountType
     * @return \App\Library\ExactTarget\StructType\AccountDataItem
     */
    public function setAccountType($accountType = null)
    {
        // validation for constraint: int
        if (!is_null($accountType) && !is_numeric($accountType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountType)), __LINE__);
        }
        if (is_null($accountType) || (is_array($accountType) && empty($accountType))) {
            unset($this->AccountType);
        } else {
            $this->AccountType = $accountType;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\AccountDataItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
