<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for APIFault StructType
 * @subpackage Structs
 */
class APIFault extends AbstractStructBase
{
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Code;
    /**
     * The Message
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Message;
    /**
     * The LogID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $LogID;
    /**
     * The Params
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\Params
     */
    public $Params;
    /**
     * Constructor method for APIFault
     * @uses APIFault::setCode()
     * @uses APIFault::setMessage()
     * @uses APIFault::setLogID()
     * @uses APIFault::setParams()
     * @param int $code
     * @param string $message
     * @param int $logID
     * @param \App\Library\ExactTarget\StructType\Params $params
     */
    public function __construct($code = null, $message = null, $logID = null, \App\Library\ExactTarget\StructType\Params $params = null)
    {
        $this
            ->setCode($code)
            ->setMessage($message)
            ->setLogID($logID)
            ->setParams($params);
    }
    /**
     * Get Code value
     * @return int
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param int $code
     * @return \App\Library\ExactTarget\StructType\APIFault
     */
    public function setCode($code = null)
    {
        // validation for constraint: int
        if (!is_null($code) && !is_numeric($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Message value
     * @return string
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \App\Library\ExactTarget\StructType\APIFault
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }
    /**
     * Get LogID value
     * @return int|null
     */
    public function getLogID()
    {
        return $this->LogID;
    }
    /**
     * Set LogID value
     * @param int $logID
     * @return \App\Library\ExactTarget\StructType\APIFault
     */
    public function setLogID($logID = null)
    {
        // validation for constraint: int
        if (!is_null($logID) && !is_numeric($logID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($logID)), __LINE__);
        }
        $this->LogID = $logID;
        return $this;
    }
    /**
     * Get Params value
     * @return \App\Library\ExactTarget\StructType\Params|null
     */
    public function getParams()
    {
        return $this->Params;
    }
    /**
     * Set Params value
     * @param \App\Library\ExactTarget\StructType\Params $params
     * @return \App\Library\ExactTarget\StructType\APIFault
     */
    public function setParams(\App\Library\ExactTarget\StructType\Params $params = null)
    {
        $this->Params = $params;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\APIFault
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
