<?php

namespace App\Library\ExactTarget\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Schedule ServiceType
 * @subpackage Services
 */
class Schedule extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Schedule
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Library\ExactTarget\StructType\ScheduleRequestMsg $parameters
     * @return \App\Library\ExactTarget\StructType\ScheduleResponseMsg|bool
     */
    public function Schedule(\App\Library\ExactTarget\StructType\ScheduleRequestMsg $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->Schedule($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App\Library\ExactTarget\StructType\ScheduleResponseMsg
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
