<?php

namespace App\Library\ExactTarget\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Query ServiceType
 * @subpackage Services
 */
class Query extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Query
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Library\ExactTarget\StructType\QueryRequestMsg $parameters
     * @return \App\Library\ExactTarget\StructType\QueryResponseMsg|bool
     */
    public function Query(\App\Library\ExactTarget\StructType\QueryRequestMsg $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->Query($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App\Library\ExactTarget\StructType\QueryResponseMsg
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
