<?php

namespace App\Library\ExactTarget\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Configure ServiceType
 * @subpackage Services
 */
class Configure extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Configure
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Library\ExactTarget\StructType\ConfigureRequestMsg $parameters
     * @return \App\Library\ExactTarget\StructType\ConfigureResponseMsg|bool
     */
    public function Configure(\App\Library\ExactTarget\StructType\ConfigureRequestMsg $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->Configure($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App\Library\ExactTarget\StructType\ConfigureResponseMsg
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
