<?php

namespace App\Library\ExactTarget\EnumType;

/**
 * This class stands for YearlyRecurrencePatternTypeEnum EnumType
 * @subpackage Enumerations
 */
class YearlyRecurrencePatternTypeEnum
{
    /**
     * Constant for value 'ByDay'
     * @return string 'ByDay'
     */
    const VALUE_BY_DAY = 'ByDay';
    /**
     * Constant for value 'ByWeek'
     * @return string 'ByWeek'
     */
    const VALUE_BY_WEEK = 'ByWeek';
    /**
     * Constant for value 'ByMonth'
     * @return string 'ByMonth'
     */
    const VALUE_BY_MONTH = 'ByMonth';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_BY_DAY
     * @uses self::VALUE_BY_WEEK
     * @uses self::VALUE_BY_MONTH
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BY_DAY,
            self::VALUE_BY_WEEK,
            self::VALUE_BY_MONTH,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
