<?php

namespace App\Library\ExactTarget\EnumType;

/**
 * This class stands for WeeklyRecurrencePatternTypeEnum EnumType
 * @subpackage Enumerations
 */
class WeeklyRecurrencePatternTypeEnum
{
    /**
     * Constant for value 'ByDay'
     * @return string 'ByDay'
     */
    const VALUE_BY_DAY = 'ByDay';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_BY_DAY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BY_DAY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
