<?php

namespace App\Library\ExactTarget\EnumType;

/**
 * This class stands for TriggeredSendTypeEnum EnumType
 * @subpackage Enumerations
 */
class TriggeredSendTypeEnum
{
    /**
     * Constant for value 'Continuous'
     * @return string 'Continuous'
     */
    const VALUE_CONTINUOUS = 'Continuous';
    /**
     * Constant for value 'Batched'
     * @return string 'Batched'
     */
    const VALUE_BATCHED = 'Batched';
    /**
     * Constant for value 'Scheduled'
     * @return string 'Scheduled'
     */
    const VALUE_SCHEDULED = 'Scheduled';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CONTINUOUS
     * @uses self::VALUE_BATCHED
     * @uses self::VALUE_SCHEDULED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CONTINUOUS,
            self::VALUE_BATCHED,
            self::VALUE_SCHEDULED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
