<?php

namespace App\Library\ExactTarget\EnumType;

/**
 * This class stands for TriggeredSendStatusEnum EnumType
 * @subpackage Enumerations
 */
class TriggeredSendStatusEnum
{
    /**
     * Constant for value 'New'
     * @return string 'New'
     */
    const VALUE_NEW = 'New';
    /**
     * Constant for value 'Inactive'
     * @return string 'Inactive'
     */
    const VALUE_INACTIVE = 'Inactive';
    /**
     * Constant for value 'Active'
     * @return string 'Active'
     */
    const VALUE_ACTIVE = 'Active';
    /**
     * Constant for value 'Canceled'
     * @return string 'Canceled'
     */
    const VALUE_CANCELED = 'Canceled';
    /**
     * Constant for value 'Deleted'
     * @return string 'Deleted'
     */
    const VALUE_DELETED = 'Deleted';
    /**
     * Constant for value 'Moved'
     * @return string 'Moved'
     */
    const VALUE_MOVED = 'Moved';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NEW
     * @uses self::VALUE_INACTIVE
     * @uses self::VALUE_ACTIVE
     * @uses self::VALUE_CANCELED
     * @uses self::VALUE_DELETED
     * @uses self::VALUE_MOVED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NEW,
            self::VALUE_INACTIVE,
            self::VALUE_ACTIVE,
            self::VALUE_CANCELED,
            self::VALUE_DELETED,
            self::VALUE_MOVED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
