<?php

namespace App\Library\ExactTarget\EnumType;

/**
 * This class stands for SystemStatusType EnumType
 * @subpackage Enumerations
 */
class SystemStatusType
{
    /**
     * Constant for value 'OK'
     * @return string 'OK'
     */
    const VALUE_OK = 'OK';
    /**
     * Constant for value 'UnplannedOutage'
     * @return string 'UnplannedOutage'
     */
    const VALUE_UNPLANNED_OUTAGE = 'UnplannedOutage';
    /**
     * Constant for value 'InMaintenance'
     * @return string 'InMaintenance'
     */
    const VALUE_IN_MAINTENANCE = 'InMaintenance';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_OK
     * @uses self::VALUE_UNPLANNED_OUTAGE
     * @uses self::VALUE_IN_MAINTENANCE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_OK,
            self::VALUE_UNPLANNED_OUTAGE,
            self::VALUE_IN_MAINTENANCE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
