<?php

namespace App\Library\ExactTarget\EnumType;

/**
 * This class stands for SubscriberAddressStatus EnumType
 * @subpackage Enumerations
 */
class SubscriberAddressStatus
{
    /**
     * Constant for value 'OptedIn'
     * @return string 'OptedIn'
     */
    const VALUE_OPTED_IN = 'OptedIn';
    /**
     * Constant for value 'OptedOut'
     * @return string 'OptedOut'
     */
    const VALUE_OPTED_OUT = 'OptedOut';
    /**
     * Constant for value 'InActive'
     * @return string 'InActive'
     */
    const VALUE_IN_ACTIVE = 'InActive';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_OPTED_IN
     * @uses self::VALUE_OPTED_OUT
     * @uses self::VALUE_IN_ACTIVE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_OPTED_IN,
            self::VALUE_OPTED_OUT,
            self::VALUE_IN_ACTIVE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
