<?php

namespace App\Library\ExactTarget\EnumType;

/**
 * This class stands for SendPriorityEnum EnumType
 * @subpackage Enumerations
 */
class SendPriorityEnum
{
    /**
     * Constant for value 'Burst'
     * @return string 'Burst'
     */
    const VALUE_BURST = 'Burst';
    /**
     * Constant for value 'Normal'
     * @return string 'Normal'
     */
    const VALUE_NORMAL = 'Normal';
    /**
     * Constant for value 'Low'
     * @return string 'Low'
     */
    const VALUE_LOW = 'Low';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_BURST
     * @uses self::VALUE_NORMAL
     * @uses self::VALUE_LOW
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BURST,
            self::VALUE_NORMAL,
            self::VALUE_LOW,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
