<?php

namespace App\Library\ExactTarget\EnumType;

/**
 * This class stands for RespondWhen EnumType
 * @subpackage Enumerations
 */
class RespondWhen
{
    /**
     * Constant for value 'Never'
     * @return string 'Never'
     */
    const VALUE_NEVER = 'Never';
    /**
     * Constant for value 'OnError'
     * @return string 'OnError'
     */
    const VALUE_ON_ERROR = 'OnError';
    /**
     * Constant for value 'Always'
     * @return string 'Always'
     */
    const VALUE_ALWAYS = 'Always';
    /**
     * Constant for value 'OnConversationError'
     * @return string 'OnConversationError'
     */
    const VALUE_ON_CONVERSATION_ERROR = 'OnConversationError';
    /**
     * Constant for value 'OnConversationComplete'
     * @return string 'OnConversationComplete'
     */
    const VALUE_ON_CONVERSATION_COMPLETE = 'OnConversationComplete';
    /**
     * Constant for value 'OnCallComplete'
     * @return string 'OnCallComplete'
     */
    const VALUE_ON_CALL_COMPLETE = 'OnCallComplete';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NEVER
     * @uses self::VALUE_ON_ERROR
     * @uses self::VALUE_ALWAYS
     * @uses self::VALUE_ON_CONVERSATION_ERROR
     * @uses self::VALUE_ON_CONVERSATION_COMPLETE
     * @uses self::VALUE_ON_CALL_COMPLETE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NEVER,
            self::VALUE_ON_ERROR,
            self::VALUE_ALWAYS,
            self::VALUE_ON_CONVERSATION_ERROR,
            self::VALUE_ON_CONVERSATION_COMPLETE,
            self::VALUE_ON_CALL_COMPLETE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
