<?php

namespace App\Library\ExactTarget\EnumType;

/**
 * This class stands for PropertyType EnumType
 * @subpackage Enumerations
 */
class PropertyType
{
    /**
     * Constant for value 'string'
     * @return string 'string'
     */
    const VALUE_STRING = 'string';
    /**
     * Constant for value 'boolean'
     * @return string 'boolean'
     */
    const VALUE_BOOLEAN = 'boolean';
    /**
     * Constant for value 'double'
     * @return string 'double'
     */
    const VALUE_DOUBLE = 'double';
    /**
     * Constant for value 'datetime'
     * @return string 'datetime'
     */
    const VALUE_DATETIME = 'datetime';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_STRING
     * @uses self::VALUE_BOOLEAN
     * @uses self::VALUE_DOUBLE
     * @uses self::VALUE_DATETIME
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_STRING,
            self::VALUE_BOOLEAN,
            self::VALUE_DOUBLE,
            self::VALUE_DATETIME,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
