<?php

namespace App\Library\ExactTarget\EnumType;

/**
 * This class stands for OverrideType EnumType
 * @subpackage Enumerations
 */
class OverrideType
{
    /**
     * Constant for value 'DoNotOverride'
     * @return string 'DoNotOverride'
     */
    const VALUE_DO_NOT_OVERRIDE = 'DoNotOverride';
    /**
     * Constant for value 'Override'
     * @return string 'Override'
     */
    const VALUE_OVERRIDE = 'Override';
    /**
     * Constant for value 'OverrideExceptWhenNull'
     * @return string 'OverrideExceptWhenNull'
     */
    const VALUE_OVERRIDE_EXCEPT_WHEN_NULL = 'OverrideExceptWhenNull';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DO_NOT_OVERRIDE
     * @uses self::VALUE_OVERRIDE
     * @uses self::VALUE_OVERRIDE_EXCEPT_WHEN_NULL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DO_NOT_OVERRIDE,
            self::VALUE_OVERRIDE,
            self::VALUE_OVERRIDE_EXCEPT_WHEN_NULL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
