<?php

namespace App\Library\ExactTarget\EnumType;

/**
 * This class stands for MessageDeliveryTypeEnum EnumType
 * @subpackage Enumerations
 */
class MessageDeliveryTypeEnum
{
    /**
     * Constant for value 'Standard'
     * @return string 'Standard'
     */
    const VALUE_STANDARD = 'Standard';
    /**
     * Constant for value 'DelayedDeliveryByMTAQueue'
     * @return string 'DelayedDeliveryByMTAQueue'
     */
    const VALUE_DELAYED_DELIVERY_BY_MTAQUEUE = 'DelayedDeliveryByMTAQueue';
    /**
     * Constant for value 'DelayedDeliveryByOMMQueue'
     * @return string 'DelayedDeliveryByOMMQueue'
     */
    const VALUE_DELAYED_DELIVERY_BY_OMMQUEUE = 'DelayedDeliveryByOMMQueue';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_STANDARD
     * @uses self::VALUE_DELAYED_DELIVERY_BY_MTAQUEUE
     * @uses self::VALUE_DELAYED_DELIVERY_BY_OMMQUEUE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_STANDARD,
            self::VALUE_DELAYED_DELIVERY_BY_MTAQUEUE,
            self::VALUE_DELAYED_DELIVERY_BY_OMMQUEUE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
