<?php

namespace App\Library\ExactTarget\EnumType;

/**
 * This class stands for LogicalOperators EnumType
 * @subpackage Enumerations
 */
class LogicalOperators
{
    /**
     * Constant for value 'OR'
     * @return string 'OR'
     */
    const VALUE_OR = 'OR';
    /**
     * Constant for value 'AND'
     * @return string 'AND'
     */
    const VALUE_AND = 'AND';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_OR
     * @uses self::VALUE_AND
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_OR,
            self::VALUE_AND,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
