<?php

namespace App\Library\ExactTarget\EnumType;

/**
 * This class stands for ListClassificationEnum EnumType
 * @subpackage Enumerations
 */
class ListClassificationEnum
{
    /**
     * Constant for value 'ExactTargetList'
     * @return string 'ExactTargetList'
     */
    const VALUE_EXACT_TARGET_LIST = 'ExactTargetList';
    /**
     * Constant for value 'PublicationList'
     * @return string 'PublicationList'
     */
    const VALUE_PUBLICATION_LIST = 'PublicationList';
    /**
     * Constant for value 'SuppressionList'
     * @return string 'SuppressionList'
     */
    const VALUE_SUPPRESSION_LIST = 'SuppressionList';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_EXACT_TARGET_LIST
     * @uses self::VALUE_PUBLICATION_LIST
     * @uses self::VALUE_SUPPRESSION_LIST
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_EXACT_TARGET_LIST,
            self::VALUE_PUBLICATION_LIST,
            self::VALUE_SUPPRESSION_LIST,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
