<?php

namespace App\Library\ExactTarget\EnumType;

/**
 * This class stands for LayoutType EnumType
 * @subpackage Enumerations
 */
class LayoutType
{
    /**
     * Constant for value 'HTMLWrapped'
     * @return string 'HTMLWrapped'
     */
    const VALUE_HTMLWRAPPED = 'HTMLWrapped';
    /**
     * Constant for value 'RawText'
     * @return string 'RawText'
     */
    const VALUE_RAW_TEXT = 'RawText';
    /**
     * Constant for value 'SMS'
     * @return string 'SMS'
     */
    const VALUE_SMS = 'SMS';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_HTMLWRAPPED
     * @uses self::VALUE_RAW_TEXT
     * @uses self::VALUE_SMS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_HTMLWRAPPED,
            self::VALUE_RAW_TEXT,
            self::VALUE_SMS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
