<?php

namespace App\Library\ExactTarget\EnumType;

/**
 * This class stands for ImportDefinitionUpdateType EnumType
 * @subpackage Enumerations
 */
class ImportDefinitionUpdateType
{
    /**
     * Constant for value 'AddAndUpdate'
     * @return string 'AddAndUpdate'
     */
    const VALUE_ADD_AND_UPDATE = 'AddAndUpdate';
    /**
     * Constant for value 'AddAndDoNotUpdate'
     * @return string 'AddAndDoNotUpdate'
     */
    const VALUE_ADD_AND_DO_NOT_UPDATE = 'AddAndDoNotUpdate';
    /**
     * Constant for value 'UpdateButDoNotAdd'
     * @return string 'UpdateButDoNotAdd'
     */
    const VALUE_UPDATE_BUT_DO_NOT_ADD = 'UpdateButDoNotAdd';
    /**
     * Constant for value 'Merge'
     * @return string 'Merge'
     */
    const VALUE_MERGE = 'Merge';
    /**
     * Constant for value 'Overwrite'
     * @return string 'Overwrite'
     */
    const VALUE_OVERWRITE = 'Overwrite';
    /**
     * Constant for value 'ColumnBased'
     * @return string 'ColumnBased'
     */
    const VALUE_COLUMN_BASED = 'ColumnBased';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ADD_AND_UPDATE
     * @uses self::VALUE_ADD_AND_DO_NOT_UPDATE
     * @uses self::VALUE_UPDATE_BUT_DO_NOT_ADD
     * @uses self::VALUE_MERGE
     * @uses self::VALUE_OVERWRITE
     * @uses self::VALUE_COLUMN_BASED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ADD_AND_UPDATE,
            self::VALUE_ADD_AND_DO_NOT_UPDATE,
            self::VALUE_UPDATE_BUT_DO_NOT_ADD,
            self::VALUE_MERGE,
            self::VALUE_OVERWRITE,
            self::VALUE_COLUMN_BASED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
