<?php

namespace App\Library\ExactTarget\EnumType;

/**
 * This class stands for ImportDefinitionFieldMappingType EnumType
 * @subpackage Enumerations
 */
class ImportDefinitionFieldMappingType
{
    /**
     * Constant for value 'InferFromColumnHeadings'
     * @return string 'InferFromColumnHeadings'
     */
    const VALUE_INFER_FROM_COLUMN_HEADINGS = 'InferFromColumnHeadings';
    /**
     * Constant for value 'MapByOrdinal'
     * @return string 'MapByOrdinal'
     */
    const VALUE_MAP_BY_ORDINAL = 'MapByOrdinal';
    /**
     * Constant for value 'ManualMap'
     * @return string 'ManualMap'
     */
    const VALUE_MANUAL_MAP = 'ManualMap';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_INFER_FROM_COLUMN_HEADINGS
     * @uses self::VALUE_MAP_BY_ORDINAL
     * @uses self::VALUE_MANUAL_MAP
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_INFER_FROM_COLUMN_HEADINGS,
            self::VALUE_MAP_BY_ORDINAL,
            self::VALUE_MANUAL_MAP,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
