<?php

namespace App\Library\ExactTarget\EnumType;

/**
 * This class stands for ImportDefinitionColumnBasedActionType EnumType
 * @subpackage Enumerations
 */
class ImportDefinitionColumnBasedActionType
{
    /**
     * Constant for value 'AddAndUpdate'
     * @return string 'AddAndUpdate'
     */
    const VALUE_ADD_AND_UPDATE = 'AddAndUpdate';
    /**
     * Constant for value 'AddButDoNotUpdate'
     * @return string 'AddButDoNotUpdate'
     */
    const VALUE_ADD_BUT_DO_NOT_UPDATE = 'AddButDoNotUpdate';
    /**
     * Constant for value 'Delete'
     * @return string 'Delete'
     */
    const VALUE_DELETE = 'Delete';
    /**
     * Constant for value 'Skip'
     * @return string 'Skip'
     */
    const VALUE_SKIP = 'Skip';
    /**
     * Constant for value 'UpdateButDoNotAdd'
     * @return string 'UpdateButDoNotAdd'
     */
    const VALUE_UPDATE_BUT_DO_NOT_ADD = 'UpdateButDoNotAdd';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ADD_AND_UPDATE
     * @uses self::VALUE_ADD_BUT_DO_NOT_UPDATE
     * @uses self::VALUE_DELETE
     * @uses self::VALUE_SKIP
     * @uses self::VALUE_UPDATE_BUT_DO_NOT_ADD
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ADD_AND_UPDATE,
            self::VALUE_ADD_BUT_DO_NOT_UPDATE,
            self::VALUE_DELETE,
            self::VALUE_SKIP,
            self::VALUE_UPDATE_BUT_DO_NOT_ADD,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
