<?php

namespace App\Library\ExactTarget\EnumType;

/**
 * This class stands for HourlyRecurrencePatternTypeEnum EnumType
 * @subpackage Enumerations
 */
class HourlyRecurrencePatternTypeEnum
{
    /**
     * Constant for value 'Interval'
     * @return string 'Interval'
     */
    const VALUE_INTERVAL = 'Interval';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_INTERVAL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_INTERVAL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
