<?php

namespace App\Library\ExactTarget\EnumType;

/**
 * This class stands for FileType EnumType
 * @subpackage Enumerations
 */
class FileType
{
    /**
     * Constant for value 'CSV'
     * @return string 'CSV'
     */
    const VALUE_CSV = 'CSV';
    /**
     * Constant for value 'TAB'
     * @return string 'TAB'
     */
    const VALUE_TAB = 'TAB';
    /**
     * Constant for value 'Other'
     * @return string 'Other'
     */
    const VALUE_OTHER = 'Other';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CSV
     * @uses self::VALUE_TAB
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CSV,
            self::VALUE_TAB,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
