<?php

namespace App\Library\ExactTarget\EnumType;

/**
 * This class stands for EventType EnumType
 * @subpackage Enumerations
 */
class EventType
{
    /**
     * Constant for value 'Open'
     * @return string 'Open'
     */
    const VALUE_OPEN = 'Open';
    /**
     * Constant for value 'Click'
     * @return string 'Click'
     */
    const VALUE_CLICK = 'Click';
    /**
     * Constant for value 'HardBounce'
     * @return string 'HardBounce'
     */
    const VALUE_HARD_BOUNCE = 'HardBounce';
    /**
     * Constant for value 'SoftBounce'
     * @return string 'SoftBounce'
     */
    const VALUE_SOFT_BOUNCE = 'SoftBounce';
    /**
     * Constant for value 'OtherBounce'
     * @return string 'OtherBounce'
     */
    const VALUE_OTHER_BOUNCE = 'OtherBounce';
    /**
     * Constant for value 'Unsubscribe'
     * @return string 'Unsubscribe'
     */
    const VALUE_UNSUBSCRIBE = 'Unsubscribe';
    /**
     * Constant for value 'Sent'
     * @return string 'Sent'
     */
    const VALUE_SENT = 'Sent';
    /**
     * Constant for value 'NotSent'
     * @return string 'NotSent'
     */
    const VALUE_NOT_SENT = 'NotSent';
    /**
     * Constant for value 'Survey'
     * @return string 'Survey'
     */
    const VALUE_SURVEY = 'Survey';
    /**
     * Constant for value 'ForwardedEmail'
     * @return string 'ForwardedEmail'
     */
    const VALUE_FORWARDED_EMAIL = 'ForwardedEmail';
    /**
     * Constant for value 'ForwardedEmailOptIn'
     * @return string 'ForwardedEmailOptIn'
     */
    const VALUE_FORWARDED_EMAIL_OPT_IN = 'ForwardedEmailOptIn';
    /**
     * Constant for value 'DeliveredEvent'
     * @return string 'DeliveredEvent'
     */
    const VALUE_DELIVERED_EVENT = 'DeliveredEvent';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_OPEN
     * @uses self::VALUE_CLICK
     * @uses self::VALUE_HARD_BOUNCE
     * @uses self::VALUE_SOFT_BOUNCE
     * @uses self::VALUE_OTHER_BOUNCE
     * @uses self::VALUE_UNSUBSCRIBE
     * @uses self::VALUE_SENT
     * @uses self::VALUE_NOT_SENT
     * @uses self::VALUE_SURVEY
     * @uses self::VALUE_FORWARDED_EMAIL
     * @uses self::VALUE_FORWARDED_EMAIL_OPT_IN
     * @uses self::VALUE_DELIVERED_EVENT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_OPEN,
            self::VALUE_CLICK,
            self::VALUE_HARD_BOUNCE,
            self::VALUE_SOFT_BOUNCE,
            self::VALUE_OTHER_BOUNCE,
            self::VALUE_UNSUBSCRIBE,
            self::VALUE_SENT,
            self::VALUE_NOT_SENT,
            self::VALUE_SURVEY,
            self::VALUE_FORWARDED_EMAIL,
            self::VALUE_FORWARDED_EMAIL_OPT_IN,
            self::VALUE_DELIVERED_EVENT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
