<?php

namespace App\Library\ExactTarget\EnumType;

/**
 * This class stands for DeliveryProfileDomainTypeEnum EnumType
 * @subpackage Enumerations
 */
class DeliveryProfileDomainTypeEnum
{
    /**
     * Constant for value 'DefaultDomain'
     * @return string 'DefaultDomain'
     */
    const VALUE_DEFAULT_DOMAIN = 'DefaultDomain';
    /**
     * Constant for value 'CustomDomain'
     * @return string 'CustomDomain'
     */
    const VALUE_CUSTOM_DOMAIN = 'CustomDomain';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DEFAULT_DOMAIN
     * @uses self::VALUE_CUSTOM_DOMAIN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DEFAULT_DOMAIN,
            self::VALUE_CUSTOM_DOMAIN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
