<?php

namespace App\Library\ExactTarget\EnumType;

/**
 * This class stands for CompressionType EnumType
 * @subpackage Enumerations
 */
class CompressionType
{
    /**
     * Constant for value 'gzip'
     * @return string 'gzip'
     */
    const VALUE_GZIP = 'gzip';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_GZIP
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_GZIP,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
