<?php

namespace App\Library\ExactTarget\EnumType;

/**
 * This class stands for AutomationSourceTypes EnumType
 * @subpackage Enumerations
 */
class AutomationSourceTypes
{
    /**
     * Constant for value 'Unknown'
     * @return string 'Unknown'
     */
    const VALUE_UNKNOWN = 'Unknown';
    /**
     * Constant for value 'FileTrigger'
     * @return string 'FileTrigger'
     */
    const VALUE_FILE_TRIGGER = 'FileTrigger';
    /**
     * Constant for value 'UserInterface'
     * @return string 'UserInterface'
     */
    const VALUE_USER_INTERFACE = 'UserInterface';
    /**
     * Constant for value 'UserAPI'
     * @return string 'UserAPI'
     */
    const VALUE_USER_API = 'UserAPI';
    /**
     * Constant for value 'RESTApi'
     * @return string 'RESTApi'
     */
    const VALUE_RESTAPI = 'RESTApi';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_FILE_TRIGGER
     * @uses self::VALUE_USER_INTERFACE
     * @uses self::VALUE_USER_API
     * @uses self::VALUE_RESTAPI
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNKNOWN,
            self::VALUE_FILE_TRIGGER,
            self::VALUE_USER_INTERFACE,
            self::VALUE_USER_API,
            self::VALUE_RESTAPI,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
