<?php

namespace App\Library\ExactTarget\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfObjectDefinitionRequest ArrayType
 * @subpackage Arrays
 */
class ArrayOfObjectDefinitionRequest extends AbstractStructArrayBase
{
    /**
     * The ObjectDefinitionRequest
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Library\ExactTarget\StructType\ObjectDefinitionRequest[]
     */
    public $ObjectDefinitionRequest;
    /**
     * Constructor method for ArrayOfObjectDefinitionRequest
     * @uses ArrayOfObjectDefinitionRequest::setObjectDefinitionRequest()
     * @param \App\Library\ExactTarget\StructType\ObjectDefinitionRequest[] $objectDefinitionRequest
     */
    public function __construct(array $objectDefinitionRequest = array())
    {
        $this
            ->setObjectDefinitionRequest($objectDefinitionRequest);
    }
    /**
     * Get ObjectDefinitionRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Library\ExactTarget\StructType\ObjectDefinitionRequest[]|null
     */
    public function getObjectDefinitionRequest()
    {
        return isset($this->ObjectDefinitionRequest) ? $this->ObjectDefinitionRequest : null;
    }
    /**
     * Set ObjectDefinitionRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\ObjectDefinitionRequest[] $objectDefinitionRequest
     * @return \App\Library\ExactTarget\ArrayType\ArrayOfObjectDefinitionRequest
     */
    public function setObjectDefinitionRequest(array $objectDefinitionRequest = array())
    {
        foreach ($objectDefinitionRequest as $arrayOfObjectDefinitionRequestObjectDefinitionRequestItem) {
            // validation for constraint: itemType
            if (!$arrayOfObjectDefinitionRequestObjectDefinitionRequestItem instanceof \App\Library\ExactTarget\StructType\ObjectDefinitionRequest) {
                throw new \InvalidArgumentException(sprintf('The ObjectDefinitionRequest property can only contain items of \App\Library\ExactTarget\StructType\ObjectDefinitionRequest, "%s" given', is_object($arrayOfObjectDefinitionRequestObjectDefinitionRequestItem) ? get_class($arrayOfObjectDefinitionRequestObjectDefinitionRequestItem) : gettype($arrayOfObjectDefinitionRequestObjectDefinitionRequestItem)), __LINE__);
            }
        }
        if (is_null($objectDefinitionRequest) || (is_array($objectDefinitionRequest) && empty($objectDefinitionRequest))) {
            unset($this->ObjectDefinitionRequest);
        } else {
            $this->ObjectDefinitionRequest = $objectDefinitionRequest;
        }
        return $this;
    }
    /**
     * Add item to ObjectDefinitionRequest value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\ObjectDefinitionRequest $item
     * @return \App\Library\ExactTarget\ArrayType\ArrayOfObjectDefinitionRequest
     */
    public function addToObjectDefinitionRequest(\App\Library\ExactTarget\StructType\ObjectDefinitionRequest $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\ObjectDefinitionRequest) {
            throw new \InvalidArgumentException(sprintf('The ObjectDefinitionRequest property can only contain items of \App\Library\ExactTarget\StructType\ObjectDefinitionRequest, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ObjectDefinitionRequest[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \App\Library\ExactTarget\StructType\ObjectDefinitionRequest|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \App\Library\ExactTarget\StructType\ObjectDefinitionRequest|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \App\Library\ExactTarget\StructType\ObjectDefinitionRequest|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \App\Library\ExactTarget\StructType\ObjectDefinitionRequest|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \App\Library\ExactTarget\StructType\ObjectDefinitionRequest|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ObjectDefinitionRequest
     */
    public function getAttributeName()
    {
        return 'ObjectDefinitionRequest';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\ArrayType\ArrayOfObjectDefinitionRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
