<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WeeklyRecurrence StructType
 * Meta informations extracted from the WSDL
 * - type: tns:WeeklyRecurrence
 * @subpackage Structs
 */
class WeeklyRecurrence extends Recurrence
{
    /**
     * The WeeklyRecurrencePatternType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WeeklyRecurrencePatternType;
    /**
     * The WeekInterval
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $WeekInterval;
    /**
     * The Sunday
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Sunday;
    /**
     * The Monday
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Monday;
    /**
     * The Tuesday
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Tuesday;
    /**
     * The Wednesday
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Wednesday;
    /**
     * The Thursday
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Thursday;
    /**
     * The Friday
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Friday;
    /**
     * The Saturday
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Saturday;
    /**
     * Constructor method for WeeklyRecurrence
     * @uses WeeklyRecurrence::setWeeklyRecurrencePatternType()
     * @uses WeeklyRecurrence::setWeekInterval()
     * @uses WeeklyRecurrence::setSunday()
     * @uses WeeklyRecurrence::setMonday()
     * @uses WeeklyRecurrence::setTuesday()
     * @uses WeeklyRecurrence::setWednesday()
     * @uses WeeklyRecurrence::setThursday()
     * @uses WeeklyRecurrence::setFriday()
     * @uses WeeklyRecurrence::setSaturday()
     * @param string $weeklyRecurrencePatternType
     * @param int $weekInterval
     * @param bool $sunday
     * @param bool $monday
     * @param bool $tuesday
     * @param bool $wednesday
     * @param bool $thursday
     * @param bool $friday
     * @param bool $saturday
     */
    public function __construct($weeklyRecurrencePatternType = null, $weekInterval = null, $sunday = null, $monday = null, $tuesday = null, $wednesday = null, $thursday = null, $friday = null, $saturday = null)
    {
        $this
            ->setWeeklyRecurrencePatternType($weeklyRecurrencePatternType)
            ->setWeekInterval($weekInterval)
            ->setSunday($sunday)
            ->setMonday($monday)
            ->setTuesday($tuesday)
            ->setWednesday($wednesday)
            ->setThursday($thursday)
            ->setFriday($friday)
            ->setSaturday($saturday);
    }
    /**
     * Get WeeklyRecurrencePatternType value
     * @return string|null
     */
    public function getWeeklyRecurrencePatternType()
    {
        return $this->WeeklyRecurrencePatternType;
    }
    /**
     * Set WeeklyRecurrencePatternType value
     * @uses \App\Library\ExactTarget\EnumType\WeeklyRecurrencePatternTypeEnum::valueIsValid()
     * @uses \App\Library\ExactTarget\EnumType\WeeklyRecurrencePatternTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $weeklyRecurrencePatternType
     * @return \App\Library\ExactTarget\StructType\WeeklyRecurrence
     */
    public function setWeeklyRecurrencePatternType($weeklyRecurrencePatternType = null)
    {
        // validation for constraint: enumeration
        if (!\App\Library\ExactTarget\EnumType\WeeklyRecurrencePatternTypeEnum::valueIsValid($weeklyRecurrencePatternType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $weeklyRecurrencePatternType, implode(', ', \App\Library\ExactTarget\EnumType\WeeklyRecurrencePatternTypeEnum::getValidValues())), __LINE__);
        }
        $this->WeeklyRecurrencePatternType = $weeklyRecurrencePatternType;
        return $this;
    }
    /**
     * Get WeekInterval value
     * @return int|null
     */
    public function getWeekInterval()
    {
        return $this->WeekInterval;
    }
    /**
     * Set WeekInterval value
     * @param int $weekInterval
     * @return \App\Library\ExactTarget\StructType\WeeklyRecurrence
     */
    public function setWeekInterval($weekInterval = null)
    {
        // validation for constraint: int
        if (!is_null($weekInterval) && !is_numeric($weekInterval)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($weekInterval)), __LINE__);
        }
        $this->WeekInterval = $weekInterval;
        return $this;
    }
    /**
     * Get Sunday value
     * @return bool|null
     */
    public function getSunday()
    {
        return $this->Sunday;
    }
    /**
     * Set Sunday value
     * @param bool $sunday
     * @return \App\Library\ExactTarget\StructType\WeeklyRecurrence
     */
    public function setSunday($sunday = null)
    {
        // validation for constraint: boolean
        if (!is_null($sunday) && !is_bool($sunday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($sunday)), __LINE__);
        }
        $this->Sunday = $sunday;
        return $this;
    }
    /**
     * Get Monday value
     * @return bool|null
     */
    public function getMonday()
    {
        return $this->Monday;
    }
    /**
     * Set Monday value
     * @param bool $monday
     * @return \App\Library\ExactTarget\StructType\WeeklyRecurrence
     */
    public function setMonday($monday = null)
    {
        // validation for constraint: boolean
        if (!is_null($monday) && !is_bool($monday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($monday)), __LINE__);
        }
        $this->Monday = $monday;
        return $this;
    }
    /**
     * Get Tuesday value
     * @return bool|null
     */
    public function getTuesday()
    {
        return $this->Tuesday;
    }
    /**
     * Set Tuesday value
     * @param bool $tuesday
     * @return \App\Library\ExactTarget\StructType\WeeklyRecurrence
     */
    public function setTuesday($tuesday = null)
    {
        // validation for constraint: boolean
        if (!is_null($tuesday) && !is_bool($tuesday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($tuesday)), __LINE__);
        }
        $this->Tuesday = $tuesday;
        return $this;
    }
    /**
     * Get Wednesday value
     * @return bool|null
     */
    public function getWednesday()
    {
        return $this->Wednesday;
    }
    /**
     * Set Wednesday value
     * @param bool $wednesday
     * @return \App\Library\ExactTarget\StructType\WeeklyRecurrence
     */
    public function setWednesday($wednesday = null)
    {
        // validation for constraint: boolean
        if (!is_null($wednesday) && !is_bool($wednesday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($wednesday)), __LINE__);
        }
        $this->Wednesday = $wednesday;
        return $this;
    }
    /**
     * Get Thursday value
     * @return bool|null
     */
    public function getThursday()
    {
        return $this->Thursday;
    }
    /**
     * Set Thursday value
     * @param bool $thursday
     * @return \App\Library\ExactTarget\StructType\WeeklyRecurrence
     */
    public function setThursday($thursday = null)
    {
        // validation for constraint: boolean
        if (!is_null($thursday) && !is_bool($thursday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($thursday)), __LINE__);
        }
        $this->Thursday = $thursday;
        return $this;
    }
    /**
     * Get Friday value
     * @return bool|null
     */
    public function getFriday()
    {
        return $this->Friday;
    }
    /**
     * Set Friday value
     * @param bool $friday
     * @return \App\Library\ExactTarget\StructType\WeeklyRecurrence
     */
    public function setFriday($friday = null)
    {
        // validation for constraint: boolean
        if (!is_null($friday) && !is_bool($friday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($friday)), __LINE__);
        }
        $this->Friday = $friday;
        return $this;
    }
    /**
     * Get Saturday value
     * @return bool|null
     */
    public function getSaturday()
    {
        return $this->Saturday;
    }
    /**
     * Set Saturday value
     * @param bool $saturday
     * @return \App\Library\ExactTarget\StructType\WeeklyRecurrence
     */
    public function setSaturday($saturday = null)
    {
        // validation for constraint: boolean
        if (!is_null($saturday) && !is_bool($saturday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($saturday)), __LINE__);
        }
        $this->Saturday = $saturday;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\WeeklyRecurrence
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
