<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VersionInfoResponseMsg StructType
 * @subpackage Structs
 */
class VersionInfoResponseMsg extends AbstractStructBase
{
    /**
     * The VersionInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \App\Library\ExactTarget\StructType\VersionInfoResponse
     */
    public $VersionInfo;
    /**
     * The RequestID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RequestID;
    /**
     * Constructor method for VersionInfoResponseMsg
     * @uses VersionInfoResponseMsg::setVersionInfo()
     * @uses VersionInfoResponseMsg::setRequestID()
     * @param \App\Library\ExactTarget\StructType\VersionInfoResponse $versionInfo
     * @param string $requestID
     */
    public function __construct(\App\Library\ExactTarget\StructType\VersionInfoResponse $versionInfo = null, $requestID = null)
    {
        $this
            ->setVersionInfo($versionInfo)
            ->setRequestID($requestID);
    }
    /**
     * Get VersionInfo value
     * @return \App\Library\ExactTarget\StructType\VersionInfoResponse
     */
    public function getVersionInfo()
    {
        return $this->VersionInfo;
    }
    /**
     * Set VersionInfo value
     * @param \App\Library\ExactTarget\StructType\VersionInfoResponse $versionInfo
     * @return \App\Library\ExactTarget\StructType\VersionInfoResponseMsg
     */
    public function setVersionInfo(\App\Library\ExactTarget\StructType\VersionInfoResponse $versionInfo = null)
    {
        $this->VersionInfo = $versionInfo;
        return $this;
    }
    /**
     * Get RequestID value
     * @return string|null
     */
    public function getRequestID()
    {
        return $this->RequestID;
    }
    /**
     * Set RequestID value
     * @param string $requestID
     * @return \App\Library\ExactTarget\StructType\VersionInfoResponseMsg
     */
    public function setRequestID($requestID = null)
    {
        // validation for constraint: string
        if (!is_null($requestID) && !is_string($requestID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestID)), __LINE__);
        }
        $this->RequestID = $requestID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\VersionInfoResponseMsg
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
