<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValidationOptions StructType
 * @subpackage Structs
 */
class ValidationOptions extends AbstractStructBase
{
    /**
     * The ValidationOption
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\APIProperty[]
     */
    public $ValidationOption;
    /**
     * Constructor method for ValidationOptions
     * @uses ValidationOptions::setValidationOption()
     * @param \App\Library\ExactTarget\StructType\APIProperty[] $validationOption
     */
    public function __construct(array $validationOption = array())
    {
        $this
            ->setValidationOption($validationOption);
    }
    /**
     * Get ValidationOption value
     * @return \App\Library\ExactTarget\StructType\APIProperty[]|null
     */
    public function getValidationOption()
    {
        return $this->ValidationOption;
    }
    /**
     * Set ValidationOption value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\APIProperty[] $validationOption
     * @return \App\Library\ExactTarget\StructType\ValidationOptions
     */
    public function setValidationOption(array $validationOption = array())
    {
        foreach ($validationOption as $validationOptionsValidationOptionItem) {
            // validation for constraint: itemType
            if (!$validationOptionsValidationOptionItem instanceof \App\Library\ExactTarget\StructType\APIProperty) {
                throw new \InvalidArgumentException(sprintf('The ValidationOption property can only contain items of \App\Library\ExactTarget\StructType\APIProperty, "%s" given', is_object($validationOptionsValidationOptionItem) ? get_class($validationOptionsValidationOptionItem) : gettype($validationOptionsValidationOptionItem)), __LINE__);
            }
        }
        $this->ValidationOption = $validationOption;
        return $this;
    }
    /**
     * Add item to ValidationOption value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\APIProperty $item
     * @return \App\Library\ExactTarget\StructType\ValidationOptions
     */
    public function addToValidationOption(\App\Library\ExactTarget\StructType\APIProperty $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\APIProperty) {
            throw new \InvalidArgumentException(sprintf('The ValidationOption property can only contain items of \App\Library\ExactTarget\StructType\APIProperty, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ValidationOption[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\ValidationOptions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
