<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValidationAction StructType
 * @subpackage Structs
 */
class ValidationAction extends AbstractStructBase
{
    /**
     * The ValidationType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ValidationType;
    /**
     * The ValidationOptions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\ValidationOptions
     */
    public $ValidationOptions;
    /**
     * Constructor method for ValidationAction
     * @uses ValidationAction::setValidationType()
     * @uses ValidationAction::setValidationOptions()
     * @param string $validationType
     * @param \App\Library\ExactTarget\StructType\ValidationOptions $validationOptions
     */
    public function __construct($validationType = null, \App\Library\ExactTarget\StructType\ValidationOptions $validationOptions = null)
    {
        $this
            ->setValidationType($validationType)
            ->setValidationOptions($validationOptions);
    }
    /**
     * Get ValidationType value
     * @return string|null
     */
    public function getValidationType()
    {
        return $this->ValidationType;
    }
    /**
     * Set ValidationType value
     * @param string $validationType
     * @return \App\Library\ExactTarget\StructType\ValidationAction
     */
    public function setValidationType($validationType = null)
    {
        // validation for constraint: string
        if (!is_null($validationType) && !is_string($validationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($validationType)), __LINE__);
        }
        $this->ValidationType = $validationType;
        return $this;
    }
    /**
     * Get ValidationOptions value
     * @return \App\Library\ExactTarget\StructType\ValidationOptions|null
     */
    public function getValidationOptions()
    {
        return $this->ValidationOptions;
    }
    /**
     * Set ValidationOptions value
     * @param \App\Library\ExactTarget\StructType\ValidationOptions $validationOptions
     * @return \App\Library\ExactTarget\StructType\ValidationAction
     */
    public function setValidationOptions(\App\Library\ExactTarget\StructType\ValidationOptions $validationOptions = null)
    {
        $this->ValidationOptions = $validationOptions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\ValidationAction
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
