<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateOptions StructType
 * Meta informations extracted from the WSDL
 * - type: tns:UpdateOptions
 * @subpackage Structs
 */
class UpdateOptions extends Options
{
    /**
     * The Container
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\ContainerID
     */
    public $Container;
    /**
     * The Action
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Action;
    /**
     * Constructor method for UpdateOptions
     * @uses UpdateOptions::setContainer()
     * @uses UpdateOptions::setAction()
     * @param \App\Library\ExactTarget\StructType\ContainerID $container
     * @param string $action
     */
    public function __construct(\App\Library\ExactTarget\StructType\ContainerID $container = null, $action = null)
    {
        $this
            ->setContainer($container)
            ->setAction($action);
    }
    /**
     * Get Container value
     * @return \App\Library\ExactTarget\StructType\ContainerID|null
     */
    public function getContainer()
    {
        return $this->Container;
    }
    /**
     * Set Container value
     * @param \App\Library\ExactTarget\StructType\ContainerID $container
     * @return \App\Library\ExactTarget\StructType\UpdateOptions
     */
    public function setContainer(\App\Library\ExactTarget\StructType\ContainerID $container = null)
    {
        $this->Container = $container;
        return $this;
    }
    /**
     * Get Action value
     * @return string|null
     */
    public function getAction()
    {
        return $this->Action;
    }
    /**
     * Set Action value
     * @param string $action
     * @return \App\Library\ExactTarget\StructType\UpdateOptions
     */
    public function setAction($action = null)
    {
        // validation for constraint: string
        if (!is_null($action) && !is_string($action)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($action)), __LINE__);
        }
        $this->Action = $action;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\UpdateOptions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
