<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TriggeredSend StructType
 * Meta informations extracted from the WSDL
 * - type: tns:TriggeredSend
 * @subpackage Structs
 */
class TriggeredSend extends APIObject
{
    /**
     * The TriggeredSendDefinition
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \App\Library\ExactTarget\StructType\TriggeredSendDefinition
     */
    public $TriggeredSendDefinition;
    /**
     * The Subscribers
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \App\Library\ExactTarget\StructType\Subscriber[]
     */
    public $Subscribers;
    /**
     * The Attributes
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\Attribute[]
     */
    public $Attributes;
    /**
     * Constructor method for TriggeredSend
     * @uses TriggeredSend::setTriggeredSendDefinition()
     * @uses TriggeredSend::setSubscribers()
     * @uses TriggeredSend::setAttributes()
     * @param \App\Library\ExactTarget\StructType\TriggeredSendDefinition $triggeredSendDefinition
     * @param \App\Library\ExactTarget\StructType\Subscriber[] $subscribers
     * @param \App\Library\ExactTarget\StructType\Attribute[] $attributes
     */
    public function __construct(\App\Library\ExactTarget\StructType\TriggeredSendDefinition $triggeredSendDefinition = null, array $subscribers = array(), array $attributes = array())
    {
        $this
            ->setTriggeredSendDefinition($triggeredSendDefinition)
            ->setSubscribers($subscribers)
            ->setAttributes($attributes);
    }
    /**
     * Get TriggeredSendDefinition value
     * @return \App\Library\ExactTarget\StructType\TriggeredSendDefinition
     */
    public function getTriggeredSendDefinition()
    {
        return $this->TriggeredSendDefinition;
    }
    /**
     * Set TriggeredSendDefinition value
     * @param \App\Library\ExactTarget\StructType\TriggeredSendDefinition $triggeredSendDefinition
     * @return \App\Library\ExactTarget\StructType\TriggeredSend
     */
    public function setTriggeredSendDefinition(\App\Library\ExactTarget\StructType\TriggeredSendDefinition $triggeredSendDefinition = null)
    {
        $this->TriggeredSendDefinition = $triggeredSendDefinition;
        return $this;
    }
    /**
     * Get Subscribers value
     * @return \App\Library\ExactTarget\StructType\Subscriber[]
     */
    public function getSubscribers()
    {
        return $this->Subscribers;
    }
    /**
     * Set Subscribers value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\Subscriber[] $subscribers
     * @return \App\Library\ExactTarget\StructType\TriggeredSend
     */
    public function setSubscribers(array $subscribers = array())
    {
        foreach ($subscribers as $triggeredSendSubscribersItem) {
            // validation for constraint: itemType
            if (!$triggeredSendSubscribersItem instanceof \App\Library\ExactTarget\StructType\Subscriber) {
                throw new \InvalidArgumentException(sprintf('The Subscribers property can only contain items of \App\Library\ExactTarget\StructType\Subscriber, "%s" given', is_object($triggeredSendSubscribersItem) ? get_class($triggeredSendSubscribersItem) : gettype($triggeredSendSubscribersItem)), __LINE__);
            }
        }
        $this->Subscribers = $subscribers;
        return $this;
    }
    /**
     * Add item to Subscribers value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\Subscriber $item
     * @return \App\Library\ExactTarget\StructType\TriggeredSend
     */
    public function addToSubscribers(\App\Library\ExactTarget\StructType\Subscriber $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\Subscriber) {
            throw new \InvalidArgumentException(sprintf('The Subscribers property can only contain items of \App\Library\ExactTarget\StructType\Subscriber, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Subscribers[] = $item;
        return $this;
    }
    /**
     * Get Attributes value
     * @return \App\Library\ExactTarget\StructType\Attribute[]|null
     */
    public function getAttributes()
    {
        return $this->Attributes;
    }
    /**
     * Set Attributes value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\Attribute[] $attributes
     * @return \App\Library\ExactTarget\StructType\TriggeredSend
     */
    public function setAttributes(array $attributes = array())
    {
        foreach ($attributes as $triggeredSendAttributesItem) {
            // validation for constraint: itemType
            if (!$triggeredSendAttributesItem instanceof \App\Library\ExactTarget\StructType\Attribute) {
                throw new \InvalidArgumentException(sprintf('The Attributes property can only contain items of \App\Library\ExactTarget\StructType\Attribute, "%s" given', is_object($triggeredSendAttributesItem) ? get_class($triggeredSendAttributesItem) : gettype($triggeredSendAttributesItem)), __LINE__);
            }
        }
        $this->Attributes = $attributes;
        return $this;
    }
    /**
     * Add item to Attributes value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\Attribute $item
     * @return \App\Library\ExactTarget\StructType\TriggeredSend
     */
    public function addToAttributes(\App\Library\ExactTarget\StructType\Attribute $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\Attribute) {
            throw new \InvalidArgumentException(sprintf('The Attributes property can only contain items of \App\Library\ExactTarget\StructType\Attribute, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Attributes[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\TriggeredSend
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
