<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Template StructType
 * @subpackage Structs
 */
class Template extends APIObject
{
    /**
     * The TemplateName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TemplateName;
    /**
     * The LayoutHTML
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LayoutHTML;
    /**
     * The BackgroundColor
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BackgroundColor;
    /**
     * The BorderColor
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BorderColor;
    /**
     * The BorderWidth
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $BorderWidth;
    /**
     * The Cellpadding
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Cellpadding;
    /**
     * The Cellspacing
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Cellspacing;
    /**
     * The Width
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Width;
    /**
     * The Align
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Align;
    /**
     * The ActiveFlag
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $ActiveFlag;
    /**
     * The CategoryID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $CategoryID;
    /**
     * The CategoryType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CategoryType;
    /**
     * The OwnerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $OwnerID;
    /**
     * The HeaderContent
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\ContentArea
     */
    public $HeaderContent;
    /**
     * The Layout
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\Layout
     */
    public $Layout;
    /**
     * The TemplateSubject
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TemplateSubject;
    /**
     * The IsTemplateSubjectLocked
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IsTemplateSubjectLocked;
    /**
     * The PreHeader
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PreHeader;
    /**
     * Constructor method for Template
     * @uses Template::setTemplateName()
     * @uses Template::setLayoutHTML()
     * @uses Template::setBackgroundColor()
     * @uses Template::setBorderColor()
     * @uses Template::setBorderWidth()
     * @uses Template::setCellpadding()
     * @uses Template::setCellspacing()
     * @uses Template::setWidth()
     * @uses Template::setAlign()
     * @uses Template::setActiveFlag()
     * @uses Template::setCategoryID()
     * @uses Template::setCategoryType()
     * @uses Template::setOwnerID()
     * @uses Template::setHeaderContent()
     * @uses Template::setLayout()
     * @uses Template::setTemplateSubject()
     * @uses Template::setIsTemplateSubjectLocked()
     * @uses Template::setPreHeader()
     * @param string $templateName
     * @param string $layoutHTML
     * @param string $backgroundColor
     * @param string $borderColor
     * @param int $borderWidth
     * @param int $cellpadding
     * @param int $cellspacing
     * @param int $width
     * @param string $align
     * @param int $activeFlag
     * @param int $categoryID
     * @param string $categoryType
     * @param int $ownerID
     * @param \App\Library\ExactTarget\StructType\ContentArea $headerContent
     * @param \App\Library\ExactTarget\StructType\Layout $layout
     * @param string $templateSubject
     * @param bool $isTemplateSubjectLocked
     * @param string $preHeader
     */
    public function __construct($templateName = null, $layoutHTML = null, $backgroundColor = null, $borderColor = null, $borderWidth = null, $cellpadding = null, $cellspacing = null, $width = null, $align = null, $activeFlag = null, $categoryID = null, $categoryType = null, $ownerID = null, \App\Library\ExactTarget\StructType\ContentArea $headerContent = null, \App\Library\ExactTarget\StructType\Layout $layout = null, $templateSubject = null, $isTemplateSubjectLocked = null, $preHeader = null)
    {
        $this
            ->setTemplateName($templateName)
            ->setLayoutHTML($layoutHTML)
            ->setBackgroundColor($backgroundColor)
            ->setBorderColor($borderColor)
            ->setBorderWidth($borderWidth)
            ->setCellpadding($cellpadding)
            ->setCellspacing($cellspacing)
            ->setWidth($width)
            ->setAlign($align)
            ->setActiveFlag($activeFlag)
            ->setCategoryID($categoryID)
            ->setCategoryType($categoryType)
            ->setOwnerID($ownerID)
            ->setHeaderContent($headerContent)
            ->setLayout($layout)
            ->setTemplateSubject($templateSubject)
            ->setIsTemplateSubjectLocked($isTemplateSubjectLocked)
            ->setPreHeader($preHeader);
    }
    /**
     * Get TemplateName value
     * @return string|null
     */
    public function getTemplateName()
    {
        return $this->TemplateName;
    }
    /**
     * Set TemplateName value
     * @param string $templateName
     * @return \App\Library\ExactTarget\StructType\Template
     */
    public function setTemplateName($templateName = null)
    {
        // validation for constraint: string
        if (!is_null($templateName) && !is_string($templateName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($templateName)), __LINE__);
        }
        $this->TemplateName = $templateName;
        return $this;
    }
    /**
     * Get LayoutHTML value
     * @return string|null
     */
    public function getLayoutHTML()
    {
        return $this->LayoutHTML;
    }
    /**
     * Set LayoutHTML value
     * @param string $layoutHTML
     * @return \App\Library\ExactTarget\StructType\Template
     */
    public function setLayoutHTML($layoutHTML = null)
    {
        // validation for constraint: string
        if (!is_null($layoutHTML) && !is_string($layoutHTML)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($layoutHTML)), __LINE__);
        }
        $this->LayoutHTML = $layoutHTML;
        return $this;
    }
    /**
     * Get BackgroundColor value
     * @return string|null
     */
    public function getBackgroundColor()
    {
        return $this->BackgroundColor;
    }
    /**
     * Set BackgroundColor value
     * @param string $backgroundColor
     * @return \App\Library\ExactTarget\StructType\Template
     */
    public function setBackgroundColor($backgroundColor = null)
    {
        // validation for constraint: string
        if (!is_null($backgroundColor) && !is_string($backgroundColor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($backgroundColor)), __LINE__);
        }
        $this->BackgroundColor = $backgroundColor;
        return $this;
    }
    /**
     * Get BorderColor value
     * @return string|null
     */
    public function getBorderColor()
    {
        return $this->BorderColor;
    }
    /**
     * Set BorderColor value
     * @param string $borderColor
     * @return \App\Library\ExactTarget\StructType\Template
     */
    public function setBorderColor($borderColor = null)
    {
        // validation for constraint: string
        if (!is_null($borderColor) && !is_string($borderColor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($borderColor)), __LINE__);
        }
        $this->BorderColor = $borderColor;
        return $this;
    }
    /**
     * Get BorderWidth value
     * @return int|null
     */
    public function getBorderWidth()
    {
        return $this->BorderWidth;
    }
    /**
     * Set BorderWidth value
     * @param int $borderWidth
     * @return \App\Library\ExactTarget\StructType\Template
     */
    public function setBorderWidth($borderWidth = null)
    {
        // validation for constraint: int
        if (!is_null($borderWidth) && !is_numeric($borderWidth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($borderWidth)), __LINE__);
        }
        $this->BorderWidth = $borderWidth;
        return $this;
    }
    /**
     * Get Cellpadding value
     * @return int|null
     */
    public function getCellpadding()
    {
        return $this->Cellpadding;
    }
    /**
     * Set Cellpadding value
     * @param int $cellpadding
     * @return \App\Library\ExactTarget\StructType\Template
     */
    public function setCellpadding($cellpadding = null)
    {
        // validation for constraint: int
        if (!is_null($cellpadding) && !is_numeric($cellpadding)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($cellpadding)), __LINE__);
        }
        $this->Cellpadding = $cellpadding;
        return $this;
    }
    /**
     * Get Cellspacing value
     * @return int|null
     */
    public function getCellspacing()
    {
        return $this->Cellspacing;
    }
    /**
     * Set Cellspacing value
     * @param int $cellspacing
     * @return \App\Library\ExactTarget\StructType\Template
     */
    public function setCellspacing($cellspacing = null)
    {
        // validation for constraint: int
        if (!is_null($cellspacing) && !is_numeric($cellspacing)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($cellspacing)), __LINE__);
        }
        $this->Cellspacing = $cellspacing;
        return $this;
    }
    /**
     * Get Width value
     * @return int|null
     */
    public function getWidth()
    {
        return $this->Width;
    }
    /**
     * Set Width value
     * @param int $width
     * @return \App\Library\ExactTarget\StructType\Template
     */
    public function setWidth($width = null)
    {
        // validation for constraint: int
        if (!is_null($width) && !is_numeric($width)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($width)), __LINE__);
        }
        $this->Width = $width;
        return $this;
    }
    /**
     * Get Align value
     * @return string|null
     */
    public function getAlign()
    {
        return $this->Align;
    }
    /**
     * Set Align value
     * @param string $align
     * @return \App\Library\ExactTarget\StructType\Template
     */
    public function setAlign($align = null)
    {
        // validation for constraint: string
        if (!is_null($align) && !is_string($align)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($align)), __LINE__);
        }
        $this->Align = $align;
        return $this;
    }
    /**
     * Get ActiveFlag value
     * @return int|null
     */
    public function getActiveFlag()
    {
        return $this->ActiveFlag;
    }
    /**
     * Set ActiveFlag value
     * @param int $activeFlag
     * @return \App\Library\ExactTarget\StructType\Template
     */
    public function setActiveFlag($activeFlag = null)
    {
        // validation for constraint: int
        if (!is_null($activeFlag) && !is_numeric($activeFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($activeFlag)), __LINE__);
        }
        $this->ActiveFlag = $activeFlag;
        return $this;
    }
    /**
     * Get CategoryID value
     * @return int|null
     */
    public function getCategoryID()
    {
        return $this->CategoryID;
    }
    /**
     * Set CategoryID value
     * @param int $categoryID
     * @return \App\Library\ExactTarget\StructType\Template
     */
    public function setCategoryID($categoryID = null)
    {
        // validation for constraint: int
        if (!is_null($categoryID) && !is_numeric($categoryID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($categoryID)), __LINE__);
        }
        $this->CategoryID = $categoryID;
        return $this;
    }
    /**
     * Get CategoryType value
     * @return string|null
     */
    public function getCategoryType()
    {
        return $this->CategoryType;
    }
    /**
     * Set CategoryType value
     * @param string $categoryType
     * @return \App\Library\ExactTarget\StructType\Template
     */
    public function setCategoryType($categoryType = null)
    {
        // validation for constraint: string
        if (!is_null($categoryType) && !is_string($categoryType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($categoryType)), __LINE__);
        }
        $this->CategoryType = $categoryType;
        return $this;
    }
    /**
     * Get OwnerID value
     * @return int|null
     */
    public function getOwnerID()
    {
        return $this->OwnerID;
    }
    /**
     * Set OwnerID value
     * @param int $ownerID
     * @return \App\Library\ExactTarget\StructType\Template
     */
    public function setOwnerID($ownerID = null)
    {
        // validation for constraint: int
        if (!is_null($ownerID) && !is_numeric($ownerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ownerID)), __LINE__);
        }
        $this->OwnerID = $ownerID;
        return $this;
    }
    /**
     * Get HeaderContent value
     * @return \App\Library\ExactTarget\StructType\ContentArea|null
     */
    public function getHeaderContent()
    {
        return $this->HeaderContent;
    }
    /**
     * Set HeaderContent value
     * @param \App\Library\ExactTarget\StructType\ContentArea $headerContent
     * @return \App\Library\ExactTarget\StructType\Template
     */
    public function setHeaderContent(\App\Library\ExactTarget\StructType\ContentArea $headerContent = null)
    {
        $this->HeaderContent = $headerContent;
        return $this;
    }
    /**
     * Get Layout value
     * @return \App\Library\ExactTarget\StructType\Layout|null
     */
    public function getLayout()
    {
        return $this->Layout;
    }
    /**
     * Set Layout value
     * @param \App\Library\ExactTarget\StructType\Layout $layout
     * @return \App\Library\ExactTarget\StructType\Template
     */
    public function setLayout(\App\Library\ExactTarget\StructType\Layout $layout = null)
    {
        $this->Layout = $layout;
        return $this;
    }
    /**
     * Get TemplateSubject value
     * @return string|null
     */
    public function getTemplateSubject()
    {
        return $this->TemplateSubject;
    }
    /**
     * Set TemplateSubject value
     * @param string $templateSubject
     * @return \App\Library\ExactTarget\StructType\Template
     */
    public function setTemplateSubject($templateSubject = null)
    {
        // validation for constraint: string
        if (!is_null($templateSubject) && !is_string($templateSubject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($templateSubject)), __LINE__);
        }
        $this->TemplateSubject = $templateSubject;
        return $this;
    }
    /**
     * Get IsTemplateSubjectLocked value
     * @return bool|null
     */
    public function getIsTemplateSubjectLocked()
    {
        return $this->IsTemplateSubjectLocked;
    }
    /**
     * Set IsTemplateSubjectLocked value
     * @param bool $isTemplateSubjectLocked
     * @return \App\Library\ExactTarget\StructType\Template
     */
    public function setIsTemplateSubjectLocked($isTemplateSubjectLocked = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTemplateSubjectLocked) && !is_bool($isTemplateSubjectLocked)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isTemplateSubjectLocked)), __LINE__);
        }
        $this->IsTemplateSubjectLocked = $isTemplateSubjectLocked;
        return $this;
    }
    /**
     * Get PreHeader value
     * @return string|null
     */
    public function getPreHeader()
    {
        return $this->PreHeader;
    }
    /**
     * Set PreHeader value
     * @param string $preHeader
     * @return \App\Library\ExactTarget\StructType\Template
     */
    public function setPreHeader($preHeader = null)
    {
        // validation for constraint: string
        if (!is_null($preHeader) && !is_string($preHeader)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($preHeader)), __LINE__);
        }
        $this->PreHeader = $preHeader;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\Template
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
