<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaskInstances StructType
 * @subpackage Structs
 */
class TaskInstances extends AbstractStructBase
{
    /**
     * The AutomationTaskInstance
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\AutomationTaskInstance[]
     */
    public $AutomationTaskInstance;
    /**
     * Constructor method for TaskInstances
     * @uses TaskInstances::setAutomationTaskInstance()
     * @param \App\Library\ExactTarget\StructType\AutomationTaskInstance[] $automationTaskInstance
     */
    public function __construct(array $automationTaskInstance = array())
    {
        $this
            ->setAutomationTaskInstance($automationTaskInstance);
    }
    /**
     * Get AutomationTaskInstance value
     * @return \App\Library\ExactTarget\StructType\AutomationTaskInstance[]|null
     */
    public function getAutomationTaskInstance()
    {
        return $this->AutomationTaskInstance;
    }
    /**
     * Set AutomationTaskInstance value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\AutomationTaskInstance[] $automationTaskInstance
     * @return \App\Library\ExactTarget\StructType\TaskInstances
     */
    public function setAutomationTaskInstance(array $automationTaskInstance = array())
    {
        foreach ($automationTaskInstance as $taskInstancesAutomationTaskInstanceItem) {
            // validation for constraint: itemType
            if (!$taskInstancesAutomationTaskInstanceItem instanceof \App\Library\ExactTarget\StructType\AutomationTaskInstance) {
                throw new \InvalidArgumentException(sprintf('The AutomationTaskInstance property can only contain items of \App\Library\ExactTarget\StructType\AutomationTaskInstance, "%s" given', is_object($taskInstancesAutomationTaskInstanceItem) ? get_class($taskInstancesAutomationTaskInstanceItem) : gettype($taskInstancesAutomationTaskInstanceItem)), __LINE__);
            }
        }
        $this->AutomationTaskInstance = $automationTaskInstance;
        return $this;
    }
    /**
     * Add item to AutomationTaskInstance value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\AutomationTaskInstance $item
     * @return \App\Library\ExactTarget\StructType\TaskInstances
     */
    public function addToAutomationTaskInstance(\App\Library\ExactTarget\StructType\AutomationTaskInstance $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\AutomationTaskInstance) {
            throw new \InvalidArgumentException(sprintf('The AutomationTaskInstance property can only contain items of \App\Library\ExactTarget\StructType\AutomationTaskInstance, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AutomationTaskInstance[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\TaskInstances
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
