<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Tags StructType
 * @subpackage Structs
 */
class Tags extends AbstractStructBase
{
    /**
     * The Tag
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Tag;
    /**
     * Constructor method for Tags
     * @uses Tags::setTag()
     * @param string[] $tag
     */
    public function __construct(array $tag = array())
    {
        $this
            ->setTag($tag);
    }
    /**
     * Get Tag value
     * @return string[]|null
     */
    public function getTag()
    {
        return $this->Tag;
    }
    /**
     * Set Tag value
     * @throws \InvalidArgumentException
     * @param string[] $tag
     * @return \App\Library\ExactTarget\StructType\Tags
     */
    public function setTag(array $tag = array())
    {
        foreach ($tag as $tagsTagItem) {
            // validation for constraint: itemType
            if (!is_string($tagsTagItem)) {
                throw new \InvalidArgumentException(sprintf('The Tag property can only contain items of string, "%s" given', is_object($tagsTagItem) ? get_class($tagsTagItem) : gettype($tagsTagItem)), __LINE__);
            }
        }
        $this->Tag = $tag;
        return $this;
    }
    /**
     * Add item to Tag value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \App\Library\ExactTarget\StructType\Tags
     */
    public function addToTag($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The Tag property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Tag[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\Tags
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
