<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SuppressionListDefinition StructType
 * @subpackage Structs
 */
class SuppressionListDefinition extends APIObject
{
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Category
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Category;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Contexts
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\Contexts
     */
    public $Contexts;
    /**
     * The Fields
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\Fields
     */
    public $Fields;
    /**
     * The SubscriberCount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $SubscriberCount;
    /**
     * The NotifyEmail
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NotifyEmail;
    /**
     * Constructor method for SuppressionListDefinition
     * @uses SuppressionListDefinition::setName()
     * @uses SuppressionListDefinition::setCategory()
     * @uses SuppressionListDefinition::setDescription()
     * @uses SuppressionListDefinition::setContexts()
     * @uses SuppressionListDefinition::setFields()
     * @uses SuppressionListDefinition::setSubscriberCount()
     * @uses SuppressionListDefinition::setNotifyEmail()
     * @param string $name
     * @param int $category
     * @param string $description
     * @param \App\Library\ExactTarget\StructType\Contexts $contexts
     * @param \App\Library\ExactTarget\StructType\Fields $fields
     * @param int $subscriberCount
     * @param string $notifyEmail
     */
    public function __construct($name = null, $category = null, $description = null, \App\Library\ExactTarget\StructType\Contexts $contexts = null, \App\Library\ExactTarget\StructType\Fields $fields = null, $subscriberCount = null, $notifyEmail = null)
    {
        $this
            ->setName($name)
            ->setCategory($category)
            ->setDescription($description)
            ->setContexts($contexts)
            ->setFields($fields)
            ->setSubscriberCount($subscriberCount)
            ->setNotifyEmail($notifyEmail);
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \App\Library\ExactTarget\StructType\SuppressionListDefinition
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Category value
     * @return int|null
     */
    public function getCategory()
    {
        return $this->Category;
    }
    /**
     * Set Category value
     * @param int $category
     * @return \App\Library\ExactTarget\StructType\SuppressionListDefinition
     */
    public function setCategory($category = null)
    {
        // validation for constraint: int
        if (!is_null($category) && !is_numeric($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($category)), __LINE__);
        }
        $this->Category = $category;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \App\Library\ExactTarget\StructType\SuppressionListDefinition
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Contexts value
     * @return \App\Library\ExactTarget\StructType\Contexts|null
     */
    public function getContexts()
    {
        return $this->Contexts;
    }
    /**
     * Set Contexts value
     * @param \App\Library\ExactTarget\StructType\Contexts $contexts
     * @return \App\Library\ExactTarget\StructType\SuppressionListDefinition
     */
    public function setContexts(\App\Library\ExactTarget\StructType\Contexts $contexts = null)
    {
        $this->Contexts = $contexts;
        return $this;
    }
    /**
     * Get Fields value
     * @return \App\Library\ExactTarget\StructType\Fields|null
     */
    public function getFields()
    {
        return $this->Fields;
    }
    /**
     * Set Fields value
     * @param \App\Library\ExactTarget\StructType\Fields $fields
     * @return \App\Library\ExactTarget\StructType\SuppressionListDefinition
     */
    public function setFields(\App\Library\ExactTarget\StructType\Fields $fields = null)
    {
        $this->Fields = $fields;
        return $this;
    }
    /**
     * Get SubscriberCount value
     * @return int|null
     */
    public function getSubscriberCount()
    {
        return $this->SubscriberCount;
    }
    /**
     * Set SubscriberCount value
     * @param int $subscriberCount
     * @return \App\Library\ExactTarget\StructType\SuppressionListDefinition
     */
    public function setSubscriberCount($subscriberCount = null)
    {
        // validation for constraint: int
        if (!is_null($subscriberCount) && !is_numeric($subscriberCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($subscriberCount)), __LINE__);
        }
        $this->SubscriberCount = $subscriberCount;
        return $this;
    }
    /**
     * Get NotifyEmail value
     * @return string|null
     */
    public function getNotifyEmail()
    {
        return $this->NotifyEmail;
    }
    /**
     * Set NotifyEmail value
     * @param string $notifyEmail
     * @return \App\Library\ExactTarget\StructType\SuppressionListDefinition
     */
    public function setNotifyEmail($notifyEmail = null)
    {
        // validation for constraint: string
        if (!is_null($notifyEmail) && !is_string($notifyEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($notifyEmail)), __LINE__);
        }
        $this->NotifyEmail = $notifyEmail;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\SuppressionListDefinition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
