<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SuppressionListContext StructType
 * @subpackage Structs
 */
class SuppressionListContext extends APIObject
{
    /**
     * The Context
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Context;
    /**
     * The SendClassificationType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SendClassificationType;
    /**
     * The SendClassification
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\SendClassification
     */
    public $SendClassification;
    /**
     * The Send
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\Send
     */
    public $Send;
    /**
     * The Definition
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\SuppressionListDefinition
     */
    public $Definition;
    /**
     * The AppliesToAllSends
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $AppliesToAllSends;
    /**
     * The SenderProfile
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\SenderProfile
     */
    public $SenderProfile;
    /**
     * Constructor method for SuppressionListContext
     * @uses SuppressionListContext::setContext()
     * @uses SuppressionListContext::setSendClassificationType()
     * @uses SuppressionListContext::setSendClassification()
     * @uses SuppressionListContext::setSend()
     * @uses SuppressionListContext::setDefinition()
     * @uses SuppressionListContext::setAppliesToAllSends()
     * @uses SuppressionListContext::setSenderProfile()
     * @param string $context
     * @param string $sendClassificationType
     * @param \App\Library\ExactTarget\StructType\SendClassification $sendClassification
     * @param \App\Library\ExactTarget\StructType\Send $send
     * @param \App\Library\ExactTarget\StructType\SuppressionListDefinition $definition
     * @param bool $appliesToAllSends
     * @param \App\Library\ExactTarget\StructType\SenderProfile $senderProfile
     */
    public function __construct($context = null, $sendClassificationType = null, \App\Library\ExactTarget\StructType\SendClassification $sendClassification = null, \App\Library\ExactTarget\StructType\Send $send = null, \App\Library\ExactTarget\StructType\SuppressionListDefinition $definition = null, $appliesToAllSends = null, \App\Library\ExactTarget\StructType\SenderProfile $senderProfile = null)
    {
        $this
            ->setContext($context)
            ->setSendClassificationType($sendClassificationType)
            ->setSendClassification($sendClassification)
            ->setSend($send)
            ->setDefinition($definition)
            ->setAppliesToAllSends($appliesToAllSends)
            ->setSenderProfile($senderProfile);
    }
    /**
     * Get Context value
     * @return string|null
     */
    public function getContext()
    {
        return $this->Context;
    }
    /**
     * Set Context value
     * @uses \App\Library\ExactTarget\EnumType\SuppressionListContextEnum::valueIsValid()
     * @uses \App\Library\ExactTarget\EnumType\SuppressionListContextEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $context
     * @return \App\Library\ExactTarget\StructType\SuppressionListContext
     */
    public function setContext($context = null)
    {
        // validation for constraint: enumeration
        if (!\App\Library\ExactTarget\EnumType\SuppressionListContextEnum::valueIsValid($context)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $context, implode(', ', \App\Library\ExactTarget\EnumType\SuppressionListContextEnum::getValidValues())), __LINE__);
        }
        $this->Context = $context;
        return $this;
    }
    /**
     * Get SendClassificationType value
     * @return string|null
     */
    public function getSendClassificationType()
    {
        return $this->SendClassificationType;
    }
    /**
     * Set SendClassificationType value
     * @uses \App\Library\ExactTarget\EnumType\SendClassificationTypeEnum::valueIsValid()
     * @uses \App\Library\ExactTarget\EnumType\SendClassificationTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sendClassificationType
     * @return \App\Library\ExactTarget\StructType\SuppressionListContext
     */
    public function setSendClassificationType($sendClassificationType = null)
    {
        // validation for constraint: enumeration
        if (!\App\Library\ExactTarget\EnumType\SendClassificationTypeEnum::valueIsValid($sendClassificationType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $sendClassificationType, implode(', ', \App\Library\ExactTarget\EnumType\SendClassificationTypeEnum::getValidValues())), __LINE__);
        }
        $this->SendClassificationType = $sendClassificationType;
        return $this;
    }
    /**
     * Get SendClassification value
     * @return \App\Library\ExactTarget\StructType\SendClassification|null
     */
    public function getSendClassification()
    {
        return $this->SendClassification;
    }
    /**
     * Set SendClassification value
     * @param \App\Library\ExactTarget\StructType\SendClassification $sendClassification
     * @return \App\Library\ExactTarget\StructType\SuppressionListContext
     */
    public function setSendClassification(\App\Library\ExactTarget\StructType\SendClassification $sendClassification = null)
    {
        $this->SendClassification = $sendClassification;
        return $this;
    }
    /**
     * Get Send value
     * @return \App\Library\ExactTarget\StructType\Send|null
     */
    public function getSend()
    {
        return $this->Send;
    }
    /**
     * Set Send value
     * @param \App\Library\ExactTarget\StructType\Send $send
     * @return \App\Library\ExactTarget\StructType\SuppressionListContext
     */
    public function setSend(\App\Library\ExactTarget\StructType\Send $send = null)
    {
        $this->Send = $send;
        return $this;
    }
    /**
     * Get Definition value
     * @return \App\Library\ExactTarget\StructType\SuppressionListDefinition|null
     */
    public function getDefinition()
    {
        return $this->Definition;
    }
    /**
     * Set Definition value
     * @param \App\Library\ExactTarget\StructType\SuppressionListDefinition $definition
     * @return \App\Library\ExactTarget\StructType\SuppressionListContext
     */
    public function setDefinition(\App\Library\ExactTarget\StructType\SuppressionListDefinition $definition = null)
    {
        $this->Definition = $definition;
        return $this;
    }
    /**
     * Get AppliesToAllSends value
     * @return bool|null
     */
    public function getAppliesToAllSends()
    {
        return $this->AppliesToAllSends;
    }
    /**
     * Set AppliesToAllSends value
     * @param bool $appliesToAllSends
     * @return \App\Library\ExactTarget\StructType\SuppressionListContext
     */
    public function setAppliesToAllSends($appliesToAllSends = null)
    {
        // validation for constraint: boolean
        if (!is_null($appliesToAllSends) && !is_bool($appliesToAllSends)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($appliesToAllSends)), __LINE__);
        }
        $this->AppliesToAllSends = $appliesToAllSends;
        return $this;
    }
    /**
     * Get SenderProfile value
     * @return \App\Library\ExactTarget\StructType\SenderProfile|null
     */
    public function getSenderProfile()
    {
        return $this->SenderProfile;
    }
    /**
     * Set SenderProfile value
     * @param \App\Library\ExactTarget\StructType\SenderProfile $senderProfile
     * @return \App\Library\ExactTarget\StructType\SuppressionListContext
     */
    public function setSenderProfile(\App\Library\ExactTarget\StructType\SenderProfile $senderProfile = null)
    {
        $this->SenderProfile = $senderProfile;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\SuppressionListContext
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
