<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Subscribers StructType
 * @subpackage Structs
 */
class Subscribers extends AbstractStructBase
{
    /**
     * The Subscriber
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\Subscriber[]
     */
    public $Subscriber;
    /**
     * Constructor method for Subscribers
     * @uses Subscribers::setSubscriber()
     * @param \App\Library\ExactTarget\StructType\Subscriber[] $subscriber
     */
    public function __construct(array $subscriber = array())
    {
        $this
            ->setSubscriber($subscriber);
    }
    /**
     * Get Subscriber value
     * @return \App\Library\ExactTarget\StructType\Subscriber[]|null
     */
    public function getSubscriber()
    {
        return $this->Subscriber;
    }
    /**
     * Set Subscriber value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\Subscriber[] $subscriber
     * @return \App\Library\ExactTarget\StructType\Subscribers
     */
    public function setSubscriber(array $subscriber = array())
    {
        foreach ($subscriber as $subscribersSubscriberItem) {
            // validation for constraint: itemType
            if (!$subscribersSubscriberItem instanceof \App\Library\ExactTarget\StructType\Subscriber) {
                throw new \InvalidArgumentException(sprintf('The Subscriber property can only contain items of \App\Library\ExactTarget\StructType\Subscriber, "%s" given', is_object($subscribersSubscriberItem) ? get_class($subscribersSubscriberItem) : gettype($subscribersSubscriberItem)), __LINE__);
            }
        }
        $this->Subscriber = $subscriber;
        return $this;
    }
    /**
     * Add item to Subscriber value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\Subscriber $item
     * @return \App\Library\ExactTarget\StructType\Subscribers
     */
    public function addToSubscriber(\App\Library\ExactTarget\StructType\Subscriber $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\Subscriber) {
            throw new \InvalidArgumentException(sprintf('The Subscriber property can only contain items of \App\Library\ExactTarget\StructType\Subscriber, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Subscriber[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\Subscribers
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
