<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SsoIdentity StructType
 * @subpackage Structs
 */
class SsoIdentity extends APIObject
{
    /**
     * The FederatedID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FederatedID;
    /**
     * The IsActive
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IsActive;
    /**
     * Constructor method for SsoIdentity
     * @uses SsoIdentity::setFederatedID()
     * @uses SsoIdentity::setIsActive()
     * @param string $federatedID
     * @param bool $isActive
     */
    public function __construct($federatedID = null, $isActive = null)
    {
        $this
            ->setFederatedID($federatedID)
            ->setIsActive($isActive);
    }
    /**
     * Get FederatedID value
     * @return string|null
     */
    public function getFederatedID()
    {
        return $this->FederatedID;
    }
    /**
     * Set FederatedID value
     * @param string $federatedID
     * @return \App\Library\ExactTarget\StructType\SsoIdentity
     */
    public function setFederatedID($federatedID = null)
    {
        // validation for constraint: string
        if (!is_null($federatedID) && !is_string($federatedID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($federatedID)), __LINE__);
        }
        $this->FederatedID = $federatedID;
        return $this;
    }
    /**
     * Get IsActive value
     * @return bool|null
     */
    public function getIsActive()
    {
        return $this->IsActive;
    }
    /**
     * Set IsActive value
     * @param bool $isActive
     * @return \App\Library\ExactTarget\StructType\SsoIdentity
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isActive)), __LINE__);
        }
        $this->IsActive = $isActive;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\SsoIdentity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
