<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SenderProfile StructType
 * Meta informations extracted from the WSDL
 * - type: tns:SenderProfile
 * @subpackage Structs
 */
class SenderProfile extends APIObject
{
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The FromName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FromName;
    /**
     * The FromAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FromAddress;
    /**
     * The UseDefaultRMMRules
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $UseDefaultRMMRules;
    /**
     * The AutoForwardToEmailAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AutoForwardToEmailAddress;
    /**
     * The AutoForwardToName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AutoForwardToName;
    /**
     * The DirectForward
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $DirectForward;
    /**
     * The AutoForwardTriggeredSend
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\TriggeredSendDefinition
     */
    public $AutoForwardTriggeredSend;
    /**
     * The AutoReply
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $AutoReply;
    /**
     * The AutoReplyTriggeredSend
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\TriggeredSendDefinition
     */
    public $AutoReplyTriggeredSend;
    /**
     * The SenderHeaderEmailAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SenderHeaderEmailAddress;
    /**
     * The SenderHeaderName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SenderHeaderName;
    /**
     * The DataRetentionPeriodLength
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $DataRetentionPeriodLength;
    /**
     * The DataRetentionPeriodUnitOfMeasure
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DataRetentionPeriodUnitOfMeasure;
    /**
     * The ReplyManagementRuleSet
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\APIObject
     */
    public $ReplyManagementRuleSet;
    /**
     * The ReplyToAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReplyToAddress;
    /**
     * The ReplyToDisplayName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReplyToDisplayName;
    /**
     * Constructor method for SenderProfile
     * @uses SenderProfile::setName()
     * @uses SenderProfile::setDescription()
     * @uses SenderProfile::setFromName()
     * @uses SenderProfile::setFromAddress()
     * @uses SenderProfile::setUseDefaultRMMRules()
     * @uses SenderProfile::setAutoForwardToEmailAddress()
     * @uses SenderProfile::setAutoForwardToName()
     * @uses SenderProfile::setDirectForward()
     * @uses SenderProfile::setAutoForwardTriggeredSend()
     * @uses SenderProfile::setAutoReply()
     * @uses SenderProfile::setAutoReplyTriggeredSend()
     * @uses SenderProfile::setSenderHeaderEmailAddress()
     * @uses SenderProfile::setSenderHeaderName()
     * @uses SenderProfile::setDataRetentionPeriodLength()
     * @uses SenderProfile::setDataRetentionPeriodUnitOfMeasure()
     * @uses SenderProfile::setReplyManagementRuleSet()
     * @uses SenderProfile::setReplyToAddress()
     * @uses SenderProfile::setReplyToDisplayName()
     * @param string $name
     * @param string $description
     * @param string $fromName
     * @param string $fromAddress
     * @param bool $useDefaultRMMRules
     * @param string $autoForwardToEmailAddress
     * @param string $autoForwardToName
     * @param bool $directForward
     * @param \App\Library\ExactTarget\StructType\TriggeredSendDefinition $autoForwardTriggeredSend
     * @param bool $autoReply
     * @param \App\Library\ExactTarget\StructType\TriggeredSendDefinition $autoReplyTriggeredSend
     * @param string $senderHeaderEmailAddress
     * @param string $senderHeaderName
     * @param int $dataRetentionPeriodLength
     * @param string $dataRetentionPeriodUnitOfMeasure
     * @param \App\Library\ExactTarget\StructType\APIObject $replyManagementRuleSet
     * @param string $replyToAddress
     * @param string $replyToDisplayName
     */
    public function __construct($name = null, $description = null, $fromName = null, $fromAddress = null, $useDefaultRMMRules = null, $autoForwardToEmailAddress = null, $autoForwardToName = null, $directForward = null, \App\Library\ExactTarget\StructType\TriggeredSendDefinition $autoForwardTriggeredSend = null, $autoReply = null, \App\Library\ExactTarget\StructType\TriggeredSendDefinition $autoReplyTriggeredSend = null, $senderHeaderEmailAddress = null, $senderHeaderName = null, $dataRetentionPeriodLength = null, $dataRetentionPeriodUnitOfMeasure = null, \App\Library\ExactTarget\StructType\APIObject $replyManagementRuleSet = null, $replyToAddress = null, $replyToDisplayName = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setFromName($fromName)
            ->setFromAddress($fromAddress)
            ->setUseDefaultRMMRules($useDefaultRMMRules)
            ->setAutoForwardToEmailAddress($autoForwardToEmailAddress)
            ->setAutoForwardToName($autoForwardToName)
            ->setDirectForward($directForward)
            ->setAutoForwardTriggeredSend($autoForwardTriggeredSend)
            ->setAutoReply($autoReply)
            ->setAutoReplyTriggeredSend($autoReplyTriggeredSend)
            ->setSenderHeaderEmailAddress($senderHeaderEmailAddress)
            ->setSenderHeaderName($senderHeaderName)
            ->setDataRetentionPeriodLength($dataRetentionPeriodLength)
            ->setDataRetentionPeriodUnitOfMeasure($dataRetentionPeriodUnitOfMeasure)
            ->setReplyManagementRuleSet($replyManagementRuleSet)
            ->setReplyToAddress($replyToAddress)
            ->setReplyToDisplayName($replyToDisplayName);
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \App\Library\ExactTarget\StructType\SenderProfile
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \App\Library\ExactTarget\StructType\SenderProfile
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get FromName value
     * @return string|null
     */
    public function getFromName()
    {
        return $this->FromName;
    }
    /**
     * Set FromName value
     * @param string $fromName
     * @return \App\Library\ExactTarget\StructType\SenderProfile
     */
    public function setFromName($fromName = null)
    {
        // validation for constraint: string
        if (!is_null($fromName) && !is_string($fromName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fromName)), __LINE__);
        }
        $this->FromName = $fromName;
        return $this;
    }
    /**
     * Get FromAddress value
     * @return string|null
     */
    public function getFromAddress()
    {
        return $this->FromAddress;
    }
    /**
     * Set FromAddress value
     * @param string $fromAddress
     * @return \App\Library\ExactTarget\StructType\SenderProfile
     */
    public function setFromAddress($fromAddress = null)
    {
        // validation for constraint: string
        if (!is_null($fromAddress) && !is_string($fromAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fromAddress)), __LINE__);
        }
        $this->FromAddress = $fromAddress;
        return $this;
    }
    /**
     * Get UseDefaultRMMRules value
     * @return bool|null
     */
    public function getUseDefaultRMMRules()
    {
        return $this->UseDefaultRMMRules;
    }
    /**
     * Set UseDefaultRMMRules value
     * @param bool $useDefaultRMMRules
     * @return \App\Library\ExactTarget\StructType\SenderProfile
     */
    public function setUseDefaultRMMRules($useDefaultRMMRules = null)
    {
        // validation for constraint: boolean
        if (!is_null($useDefaultRMMRules) && !is_bool($useDefaultRMMRules)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($useDefaultRMMRules)), __LINE__);
        }
        $this->UseDefaultRMMRules = $useDefaultRMMRules;
        return $this;
    }
    /**
     * Get AutoForwardToEmailAddress value
     * @return string|null
     */
    public function getAutoForwardToEmailAddress()
    {
        return $this->AutoForwardToEmailAddress;
    }
    /**
     * Set AutoForwardToEmailAddress value
     * @param string $autoForwardToEmailAddress
     * @return \App\Library\ExactTarget\StructType\SenderProfile
     */
    public function setAutoForwardToEmailAddress($autoForwardToEmailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($autoForwardToEmailAddress) && !is_string($autoForwardToEmailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($autoForwardToEmailAddress)), __LINE__);
        }
        $this->AutoForwardToEmailAddress = $autoForwardToEmailAddress;
        return $this;
    }
    /**
     * Get AutoForwardToName value
     * @return string|null
     */
    public function getAutoForwardToName()
    {
        return $this->AutoForwardToName;
    }
    /**
     * Set AutoForwardToName value
     * @param string $autoForwardToName
     * @return \App\Library\ExactTarget\StructType\SenderProfile
     */
    public function setAutoForwardToName($autoForwardToName = null)
    {
        // validation for constraint: string
        if (!is_null($autoForwardToName) && !is_string($autoForwardToName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($autoForwardToName)), __LINE__);
        }
        $this->AutoForwardToName = $autoForwardToName;
        return $this;
    }
    /**
     * Get DirectForward value
     * @return bool|null
     */
    public function getDirectForward()
    {
        return $this->DirectForward;
    }
    /**
     * Set DirectForward value
     * @param bool $directForward
     * @return \App\Library\ExactTarget\StructType\SenderProfile
     */
    public function setDirectForward($directForward = null)
    {
        // validation for constraint: boolean
        if (!is_null($directForward) && !is_bool($directForward)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($directForward)), __LINE__);
        }
        $this->DirectForward = $directForward;
        return $this;
    }
    /**
     * Get AutoForwardTriggeredSend value
     * @return \App\Library\ExactTarget\StructType\TriggeredSendDefinition|null
     */
    public function getAutoForwardTriggeredSend()
    {
        return $this->AutoForwardTriggeredSend;
    }
    /**
     * Set AutoForwardTriggeredSend value
     * @param \App\Library\ExactTarget\StructType\TriggeredSendDefinition $autoForwardTriggeredSend
     * @return \App\Library\ExactTarget\StructType\SenderProfile
     */
    public function setAutoForwardTriggeredSend(\App\Library\ExactTarget\StructType\TriggeredSendDefinition $autoForwardTriggeredSend = null)
    {
        $this->AutoForwardTriggeredSend = $autoForwardTriggeredSend;
        return $this;
    }
    /**
     * Get AutoReply value
     * @return bool|null
     */
    public function getAutoReply()
    {
        return $this->AutoReply;
    }
    /**
     * Set AutoReply value
     * @param bool $autoReply
     * @return \App\Library\ExactTarget\StructType\SenderProfile
     */
    public function setAutoReply($autoReply = null)
    {
        // validation for constraint: boolean
        if (!is_null($autoReply) && !is_bool($autoReply)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($autoReply)), __LINE__);
        }
        $this->AutoReply = $autoReply;
        return $this;
    }
    /**
     * Get AutoReplyTriggeredSend value
     * @return \App\Library\ExactTarget\StructType\TriggeredSendDefinition|null
     */
    public function getAutoReplyTriggeredSend()
    {
        return $this->AutoReplyTriggeredSend;
    }
    /**
     * Set AutoReplyTriggeredSend value
     * @param \App\Library\ExactTarget\StructType\TriggeredSendDefinition $autoReplyTriggeredSend
     * @return \App\Library\ExactTarget\StructType\SenderProfile
     */
    public function setAutoReplyTriggeredSend(\App\Library\ExactTarget\StructType\TriggeredSendDefinition $autoReplyTriggeredSend = null)
    {
        $this->AutoReplyTriggeredSend = $autoReplyTriggeredSend;
        return $this;
    }
    /**
     * Get SenderHeaderEmailAddress value
     * @return string|null
     */
    public function getSenderHeaderEmailAddress()
    {
        return $this->SenderHeaderEmailAddress;
    }
    /**
     * Set SenderHeaderEmailAddress value
     * @param string $senderHeaderEmailAddress
     * @return \App\Library\ExactTarget\StructType\SenderProfile
     */
    public function setSenderHeaderEmailAddress($senderHeaderEmailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($senderHeaderEmailAddress) && !is_string($senderHeaderEmailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($senderHeaderEmailAddress)), __LINE__);
        }
        $this->SenderHeaderEmailAddress = $senderHeaderEmailAddress;
        return $this;
    }
    /**
     * Get SenderHeaderName value
     * @return string|null
     */
    public function getSenderHeaderName()
    {
        return $this->SenderHeaderName;
    }
    /**
     * Set SenderHeaderName value
     * @param string $senderHeaderName
     * @return \App\Library\ExactTarget\StructType\SenderProfile
     */
    public function setSenderHeaderName($senderHeaderName = null)
    {
        // validation for constraint: string
        if (!is_null($senderHeaderName) && !is_string($senderHeaderName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($senderHeaderName)), __LINE__);
        }
        $this->SenderHeaderName = $senderHeaderName;
        return $this;
    }
    /**
     * Get DataRetentionPeriodLength value
     * @return int|null
     */
    public function getDataRetentionPeriodLength()
    {
        return $this->DataRetentionPeriodLength;
    }
    /**
     * Set DataRetentionPeriodLength value
     * @param int $dataRetentionPeriodLength
     * @return \App\Library\ExactTarget\StructType\SenderProfile
     */
    public function setDataRetentionPeriodLength($dataRetentionPeriodLength = null)
    {
        // validation for constraint: int
        if (!is_null($dataRetentionPeriodLength) && !is_numeric($dataRetentionPeriodLength)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($dataRetentionPeriodLength)), __LINE__);
        }
        $this->DataRetentionPeriodLength = $dataRetentionPeriodLength;
        return $this;
    }
    /**
     * Get DataRetentionPeriodUnitOfMeasure value
     * @return string|null
     */
    public function getDataRetentionPeriodUnitOfMeasure()
    {
        return $this->DataRetentionPeriodUnitOfMeasure;
    }
    /**
     * Set DataRetentionPeriodUnitOfMeasure value
     * @uses \App\Library\ExactTarget\EnumType\RecurrenceTypeEnum::valueIsValid()
     * @uses \App\Library\ExactTarget\EnumType\RecurrenceTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dataRetentionPeriodUnitOfMeasure
     * @return \App\Library\ExactTarget\StructType\SenderProfile
     */
    public function setDataRetentionPeriodUnitOfMeasure($dataRetentionPeriodUnitOfMeasure = null)
    {
        // validation for constraint: enumeration
        if (!\App\Library\ExactTarget\EnumType\RecurrenceTypeEnum::valueIsValid($dataRetentionPeriodUnitOfMeasure)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dataRetentionPeriodUnitOfMeasure, implode(', ', \App\Library\ExactTarget\EnumType\RecurrenceTypeEnum::getValidValues())), __LINE__);
        }
        $this->DataRetentionPeriodUnitOfMeasure = $dataRetentionPeriodUnitOfMeasure;
        return $this;
    }
    /**
     * Get ReplyManagementRuleSet value
     * @return \App\Library\ExactTarget\StructType\APIObject|null
     */
    public function getReplyManagementRuleSet()
    {
        return $this->ReplyManagementRuleSet;
    }
    /**
     * Set ReplyManagementRuleSet value
     * @param \App\Library\ExactTarget\StructType\APIObject $replyManagementRuleSet
     * @return \App\Library\ExactTarget\StructType\SenderProfile
     */
    public function setReplyManagementRuleSet(\App\Library\ExactTarget\StructType\APIObject $replyManagementRuleSet = null)
    {
        $this->ReplyManagementRuleSet = $replyManagementRuleSet;
        return $this;
    }
    /**
     * Get ReplyToAddress value
     * @return string|null
     */
    public function getReplyToAddress()
    {
        return $this->ReplyToAddress;
    }
    /**
     * Set ReplyToAddress value
     * @param string $replyToAddress
     * @return \App\Library\ExactTarget\StructType\SenderProfile
     */
    public function setReplyToAddress($replyToAddress = null)
    {
        // validation for constraint: string
        if (!is_null($replyToAddress) && !is_string($replyToAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($replyToAddress)), __LINE__);
        }
        $this->ReplyToAddress = $replyToAddress;
        return $this;
    }
    /**
     * Get ReplyToDisplayName value
     * @return string|null
     */
    public function getReplyToDisplayName()
    {
        return $this->ReplyToDisplayName;
    }
    /**
     * Set ReplyToDisplayName value
     * @param string $replyToDisplayName
     * @return \App\Library\ExactTarget\StructType\SenderProfile
     */
    public function setReplyToDisplayName($replyToDisplayName = null)
    {
        // validation for constraint: string
        if (!is_null($replyToDisplayName) && !is_string($replyToDisplayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($replyToDisplayName)), __LINE__);
        }
        $this->ReplyToDisplayName = $replyToDisplayName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\SenderProfile
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
