<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SendSummary StructType
 * @subpackage Structs
 */
class SendSummary extends APIObject
{
    /**
     * The AccountID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $AccountID;
    /**
     * The AccountName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountName;
    /**
     * The AccountEmail
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountEmail;
    /**
     * The IsTestAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IsTestAccount;
    /**
     * The SendID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $SendID;
    /**
     * The DeliveredTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeliveredTime;
    /**
     * The TotalSent
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $TotalSent;
    /**
     * The Transactional
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Transactional;
    /**
     * The NonTransactional
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $NonTransactional;
    /**
     * Constructor method for SendSummary
     * @uses SendSummary::setAccountID()
     * @uses SendSummary::setAccountName()
     * @uses SendSummary::setAccountEmail()
     * @uses SendSummary::setIsTestAccount()
     * @uses SendSummary::setSendID()
     * @uses SendSummary::setDeliveredTime()
     * @uses SendSummary::setTotalSent()
     * @uses SendSummary::setTransactional()
     * @uses SendSummary::setNonTransactional()
     * @param int $accountID
     * @param string $accountName
     * @param string $accountEmail
     * @param bool $isTestAccount
     * @param int $sendID
     * @param string $deliveredTime
     * @param int $totalSent
     * @param int $transactional
     * @param int $nonTransactional
     */
    public function __construct($accountID = null, $accountName = null, $accountEmail = null, $isTestAccount = null, $sendID = null, $deliveredTime = null, $totalSent = null, $transactional = null, $nonTransactional = null)
    {
        $this
            ->setAccountID($accountID)
            ->setAccountName($accountName)
            ->setAccountEmail($accountEmail)
            ->setIsTestAccount($isTestAccount)
            ->setSendID($sendID)
            ->setDeliveredTime($deliveredTime)
            ->setTotalSent($totalSent)
            ->setTransactional($transactional)
            ->setNonTransactional($nonTransactional);
    }
    /**
     * Get AccountID value
     * @return int|null
     */
    public function getAccountID()
    {
        return $this->AccountID;
    }
    /**
     * Set AccountID value
     * @param int $accountID
     * @return \App\Library\ExactTarget\StructType\SendSummary
     */
    public function setAccountID($accountID = null)
    {
        // validation for constraint: int
        if (!is_null($accountID) && !is_numeric($accountID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountID)), __LINE__);
        }
        $this->AccountID = $accountID;
        return $this;
    }
    /**
     * Get AccountName value
     * @return string|null
     */
    public function getAccountName()
    {
        return $this->AccountName;
    }
    /**
     * Set AccountName value
     * @param string $accountName
     * @return \App\Library\ExactTarget\StructType\SendSummary
     */
    public function setAccountName($accountName = null)
    {
        // validation for constraint: string
        if (!is_null($accountName) && !is_string($accountName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountName)), __LINE__);
        }
        $this->AccountName = $accountName;
        return $this;
    }
    /**
     * Get AccountEmail value
     * @return string|null
     */
    public function getAccountEmail()
    {
        return $this->AccountEmail;
    }
    /**
     * Set AccountEmail value
     * @param string $accountEmail
     * @return \App\Library\ExactTarget\StructType\SendSummary
     */
    public function setAccountEmail($accountEmail = null)
    {
        // validation for constraint: string
        if (!is_null($accountEmail) && !is_string($accountEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountEmail)), __LINE__);
        }
        $this->AccountEmail = $accountEmail;
        return $this;
    }
    /**
     * Get IsTestAccount value
     * @return bool|null
     */
    public function getIsTestAccount()
    {
        return $this->IsTestAccount;
    }
    /**
     * Set IsTestAccount value
     * @param bool $isTestAccount
     * @return \App\Library\ExactTarget\StructType\SendSummary
     */
    public function setIsTestAccount($isTestAccount = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTestAccount) && !is_bool($isTestAccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isTestAccount)), __LINE__);
        }
        $this->IsTestAccount = $isTestAccount;
        return $this;
    }
    /**
     * Get SendID value
     * @return int|null
     */
    public function getSendID()
    {
        return $this->SendID;
    }
    /**
     * Set SendID value
     * @param int $sendID
     * @return \App\Library\ExactTarget\StructType\SendSummary
     */
    public function setSendID($sendID = null)
    {
        // validation for constraint: int
        if (!is_null($sendID) && !is_numeric($sendID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sendID)), __LINE__);
        }
        $this->SendID = $sendID;
        return $this;
    }
    /**
     * Get DeliveredTime value
     * @return string|null
     */
    public function getDeliveredTime()
    {
        return $this->DeliveredTime;
    }
    /**
     * Set DeliveredTime value
     * @param string $deliveredTime
     * @return \App\Library\ExactTarget\StructType\SendSummary
     */
    public function setDeliveredTime($deliveredTime = null)
    {
        // validation for constraint: string
        if (!is_null($deliveredTime) && !is_string($deliveredTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deliveredTime)), __LINE__);
        }
        $this->DeliveredTime = $deliveredTime;
        return $this;
    }
    /**
     * Get TotalSent value
     * @return int|null
     */
    public function getTotalSent()
    {
        return $this->TotalSent;
    }
    /**
     * Set TotalSent value
     * @param int $totalSent
     * @return \App\Library\ExactTarget\StructType\SendSummary
     */
    public function setTotalSent($totalSent = null)
    {
        // validation for constraint: int
        if (!is_null($totalSent) && !is_numeric($totalSent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($totalSent)), __LINE__);
        }
        $this->TotalSent = $totalSent;
        return $this;
    }
    /**
     * Get Transactional value
     * @return int|null
     */
    public function getTransactional()
    {
        return $this->Transactional;
    }
    /**
     * Set Transactional value
     * @param int $transactional
     * @return \App\Library\ExactTarget\StructType\SendSummary
     */
    public function setTransactional($transactional = null)
    {
        // validation for constraint: int
        if (!is_null($transactional) && !is_numeric($transactional)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($transactional)), __LINE__);
        }
        $this->Transactional = $transactional;
        return $this;
    }
    /**
     * Get NonTransactional value
     * @return int|null
     */
    public function getNonTransactional()
    {
        return $this->NonTransactional;
    }
    /**
     * Set NonTransactional value
     * @param int $nonTransactional
     * @return \App\Library\ExactTarget\StructType\SendSummary
     */
    public function setNonTransactional($nonTransactional = null)
    {
        // validation for constraint: int
        if (!is_null($nonTransactional) && !is_numeric($nonTransactional)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($nonTransactional)), __LINE__);
        }
        $this->NonTransactional = $nonTransactional;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\SendSummary
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
