<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SendEmailMOKeyword StructType
 * @subpackage Structs
 */
class SendEmailMOKeyword extends BaseMOKeyword
{
    /**
     * The SuccessMessage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SuccessMessage;
    /**
     * The MissingEmailMessage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MissingEmailMessage;
    /**
     * The FailureMessage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FailureMessage;
    /**
     * The TriggeredSend
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\TriggeredSendDefinition
     */
    public $TriggeredSend;
    /**
     * The NextMOKeyword
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\BaseMOKeyword
     */
    public $NextMOKeyword;
    /**
     * Constructor method for SendEmailMOKeyword
     * @uses SendEmailMOKeyword::setSuccessMessage()
     * @uses SendEmailMOKeyword::setMissingEmailMessage()
     * @uses SendEmailMOKeyword::setFailureMessage()
     * @uses SendEmailMOKeyword::setTriggeredSend()
     * @uses SendEmailMOKeyword::setNextMOKeyword()
     * @param string $successMessage
     * @param string $missingEmailMessage
     * @param string $failureMessage
     * @param \App\Library\ExactTarget\StructType\TriggeredSendDefinition $triggeredSend
     * @param \App\Library\ExactTarget\StructType\BaseMOKeyword $nextMOKeyword
     */
    public function __construct($successMessage = null, $missingEmailMessage = null, $failureMessage = null, \App\Library\ExactTarget\StructType\TriggeredSendDefinition $triggeredSend = null, \App\Library\ExactTarget\StructType\BaseMOKeyword $nextMOKeyword = null)
    {
        $this
            ->setSuccessMessage($successMessage)
            ->setMissingEmailMessage($missingEmailMessage)
            ->setFailureMessage($failureMessage)
            ->setTriggeredSend($triggeredSend)
            ->setNextMOKeyword($nextMOKeyword);
    }
    /**
     * Get SuccessMessage value
     * @return string|null
     */
    public function getSuccessMessage()
    {
        return $this->SuccessMessage;
    }
    /**
     * Set SuccessMessage value
     * @param string $successMessage
     * @return \App\Library\ExactTarget\StructType\SendEmailMOKeyword
     */
    public function setSuccessMessage($successMessage = null)
    {
        // validation for constraint: string
        if (!is_null($successMessage) && !is_string($successMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($successMessage)), __LINE__);
        }
        $this->SuccessMessage = $successMessage;
        return $this;
    }
    /**
     * Get MissingEmailMessage value
     * @return string|null
     */
    public function getMissingEmailMessage()
    {
        return $this->MissingEmailMessage;
    }
    /**
     * Set MissingEmailMessage value
     * @param string $missingEmailMessage
     * @return \App\Library\ExactTarget\StructType\SendEmailMOKeyword
     */
    public function setMissingEmailMessage($missingEmailMessage = null)
    {
        // validation for constraint: string
        if (!is_null($missingEmailMessage) && !is_string($missingEmailMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($missingEmailMessage)), __LINE__);
        }
        $this->MissingEmailMessage = $missingEmailMessage;
        return $this;
    }
    /**
     * Get FailureMessage value
     * @return string|null
     */
    public function getFailureMessage()
    {
        return $this->FailureMessage;
    }
    /**
     * Set FailureMessage value
     * @param string $failureMessage
     * @return \App\Library\ExactTarget\StructType\SendEmailMOKeyword
     */
    public function setFailureMessage($failureMessage = null)
    {
        // validation for constraint: string
        if (!is_null($failureMessage) && !is_string($failureMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($failureMessage)), __LINE__);
        }
        $this->FailureMessage = $failureMessage;
        return $this;
    }
    /**
     * Get TriggeredSend value
     * @return \App\Library\ExactTarget\StructType\TriggeredSendDefinition|null
     */
    public function getTriggeredSend()
    {
        return $this->TriggeredSend;
    }
    /**
     * Set TriggeredSend value
     * @param \App\Library\ExactTarget\StructType\TriggeredSendDefinition $triggeredSend
     * @return \App\Library\ExactTarget\StructType\SendEmailMOKeyword
     */
    public function setTriggeredSend(\App\Library\ExactTarget\StructType\TriggeredSendDefinition $triggeredSend = null)
    {
        $this->TriggeredSend = $triggeredSend;
        return $this;
    }
    /**
     * Get NextMOKeyword value
     * @return \App\Library\ExactTarget\StructType\BaseMOKeyword|null
     */
    public function getNextMOKeyword()
    {
        return $this->NextMOKeyword;
    }
    /**
     * Set NextMOKeyword value
     * @param \App\Library\ExactTarget\StructType\BaseMOKeyword $nextMOKeyword
     * @return \App\Library\ExactTarget\StructType\SendEmailMOKeyword
     */
    public function setNextMOKeyword(\App\Library\ExactTarget\StructType\BaseMOKeyword $nextMOKeyword = null)
    {
        $this->NextMOKeyword = $nextMOKeyword;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\SendEmailMOKeyword
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
